/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.connector.AsyncHazelcastWriterP;
import com.hazelcast.jet.impl.observer.ObservableImpl;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.Ringbuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class WriteObservableP<T>
extends AsyncHazelcastWriterP {
    private static final int MAX_PARALLEL_ASYNC_OPS = 1;
    private static final int MAX_BATCH_SIZE = 1000;
    private final String observableName;
    private final List<T> batch = new ArrayList<T>(1000);
    private Ringbuffer<Object> ringbuffer;

    private WriteObservableP(String observableName, HazelcastInstance instance) {
        super(instance, 1);
        this.observableName = observableName;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.ringbuffer = this.instance().getRingbuffer(ObservableImpl.ringbufferName(this.observableName));
    }

    @Override
    protected void processInternal(Inbox inbox) {
        if (this.batch.size() < 1000) {
            inbox.drainTo(this.batch, 1000 - this.batch.size());
        }
        this.tryFlush();
    }

    @Override
    protected boolean flushInternal() {
        return this.tryFlush();
    }

    private boolean tryFlush() {
        if (this.batch.isEmpty()) {
            return true;
        }
        if (!this.tryAcquirePermit()) {
            return false;
        }
        this.setCallback(this.ringbuffer.addAllAsync(this.batch, OverflowPolicy.OVERWRITE));
        this.batch.clear();
        return true;
    }

    public static final class Supplier
    extends AbstractHazelcastConnectorSupplier {
        private final String observableName;

        public Supplier(String observableName) {
            super(null);
            this.observableName = observableName;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance) {
            return new WriteObservableP(this.observableName, instance);
        }
    }
}

