/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.internal.config.DeclarativeConfigUtil;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.config.XmlJetClientConfigLocator;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;
import com.hazelcast.jet.impl.config.XmlJetConfigLocator;
import com.hazelcast.jet.impl.config.XmlJetMemberConfigLocator;
import com.hazelcast.jet.impl.config.YamlJetClientConfigLocator;
import com.hazelcast.jet.impl.config.YamlJetConfigBuilder;
import com.hazelcast.jet.impl.config.YamlJetConfigLocator;
import com.hazelcast.jet.impl.config.YamlJetMemberConfigLocator;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConfigProvider {
    private ConfigProvider() {
    }

    @Nonnull
    public static JetConfig locateAndGetJetConfig() {
        return ConfigProvider.locateAndGetJetConfig(null);
    }

    @Nonnull
    public static JetConfig locateAndGetJetConfig(@Nullable Properties properties) {
        JetConfig config;
        DeclarativeConfigUtil.validateSuffixInSystemProperty("hazelcast.jet.config");
        XmlJetConfigLocator xmlConfigLocator = new XmlJetConfigLocator();
        YamlJetConfigLocator yamlConfigLocator = new YamlJetConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlJetConfigBuilder(yamlConfigLocator).setProperties(properties).build();
        } else if (xmlConfigLocator.locateFromSystemProperty()) {
            config = new XmlJetConfigBuilder(xmlConfigLocator).setProperties(properties).build();
        } else if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new XmlJetConfigBuilder(xmlConfigLocator).setProperties(properties).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlJetConfigBuilder(yamlConfigLocator).setProperties(properties).build();
        } else {
            xmlConfigLocator.locateDefault();
            config = new XmlJetConfigBuilder(xmlConfigLocator).setProperties(properties).build();
        }
        return config;
    }

    @Nonnull
    public static ClientConfig locateAndGetClientConfig() {
        ClientConfig config;
        DeclarativeConfigUtil.validateSuffixInSystemProperty("hazelcast.client.config");
        XmlJetClientConfigLocator xmlConfigLocator = new XmlJetClientConfigLocator();
        YamlJetClientConfigLocator yamlConfigLocator = new YamlJetClientConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlClientConfigBuilder(yamlConfigLocator.getIn()).build();
        } else if (xmlConfigLocator.locateFromSystemProperty()) {
            config = new XmlClientConfigBuilder(xmlConfigLocator.getIn()).build();
        } else if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new XmlClientConfigBuilder(xmlConfigLocator.getIn()).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlClientConfigBuilder(yamlConfigLocator.getIn()).build();
        } else {
            xmlConfigLocator.locateDefault();
            config = new XmlClientConfigBuilder(xmlConfigLocator.getIn()).build();
        }
        return config;
    }

    @Nonnull
    public static Config locateAndGetMemberConfig(@Nullable Properties properties) {
        Config config;
        DeclarativeConfigUtil.validateSuffixInSystemProperty("hazelcast.config");
        XmlJetMemberConfigLocator xmlConfigLocator = new XmlJetMemberConfigLocator();
        YamlJetMemberConfigLocator yamlConfigLocator = new YamlJetMemberConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlConfigBuilder(yamlConfigLocator.getIn()).setProperties(properties).build();
        } else if (xmlConfigLocator.locateFromSystemProperty()) {
            config = new XmlConfigBuilder(xmlConfigLocator.getIn()).setProperties(properties).build();
        } else if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new XmlConfigBuilder(xmlConfigLocator.getIn()).setProperties(properties).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlConfigBuilder(yamlConfigLocator.getIn()).setProperties(properties).build();
        } else {
            xmlConfigLocator.locateDefault();
            config = new XmlConfigBuilder(xmlConfigLocator.getIn()).setProperties(properties).build();
        }
        return config;
    }
}

