/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.Functions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.core.DefaultPartitionStrategy;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.ConstantFunctionEx;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Edge
implements IdentifiedDataSerializable {
    private Vertex source;
    private String sourceName;
    private int sourceOrdinal;
    private Vertex destination;
    private String destName;
    private int destOrdinal;
    private int priority;
    private boolean isDistributed;
    private Partitioner<?> partitioner;
    private RoutingPolicy routingPolicy = RoutingPolicy.UNICAST;
    private EdgeConfig config;

    protected Edge() {
    }

    protected Edge(@Nonnull Vertex source, int sourceOrdinal, Vertex destination, int destOrdinal) {
        this.source = source;
        this.sourceName = source.getName();
        this.sourceOrdinal = sourceOrdinal;
        this.destination = destination;
        this.destName = destination != null ? destination.getName() : null;
        this.destOrdinal = destOrdinal;
    }

    @Nonnull
    public static Edge between(@Nonnull Vertex source, @Nonnull Vertex destination) {
        return new Edge(source, 0, destination, 0);
    }

    @Nonnull
    public static Edge from(@Nonnull Vertex source) {
        return Edge.from(source, 0);
    }

    @Nonnull
    public static Edge from(@Nonnull Vertex source, int ordinal) {
        return new Edge(source, ordinal, null, 0);
    }

    @Nonnull
    public Edge to(@Nonnull Vertex destination) {
        this.destination = destination;
        this.destName = destination.getName();
        return this;
    }

    @Nonnull
    public Edge to(@Nonnull Vertex destination, int ordinal) {
        this.destination = destination;
        this.destName = destination.getName();
        this.destOrdinal = ordinal;
        return this;
    }

    @Nonnull
    public Vertex getSource() {
        return this.source;
    }

    public Vertex getDestination() {
        return this.destination;
    }

    @Nonnull
    public String getSourceName() {
        return this.sourceName;
    }

    public int getSourceOrdinal() {
        return this.sourceOrdinal;
    }

    public String getDestName() {
        return this.destName;
    }

    public int getDestOrdinal() {
        return this.destOrdinal;
    }

    @Nonnull
    public Edge priority(int priority) {
        if (priority == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("priority must not be Integer.MIN_VALUE (-2147483648)");
        }
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public Edge unicast() {
        this.routingPolicy = RoutingPolicy.UNICAST;
        return this;
    }

    @Nonnull
    public <T> Edge partitioned(@Nonnull FunctionEx<T, ?> extractKeyFn) {
        if (extractKeyFn instanceof ConstantFunctionEx) {
            return this.allToOne(extractKeyFn.apply(null));
        }
        return this.partitioned(extractKeyFn, Partitioner.defaultPartitioner());
    }

    @Nonnull
    public <T, K> Edge partitioned(@Nonnull FunctionEx<T, K> extractKeyFn, @Nonnull Partitioner<? super K> partitioner) {
        Util.checkSerializable(extractKeyFn, "extractKeyFn");
        Util.checkSerializable(partitioner, "partitioner");
        this.routingPolicy = RoutingPolicy.PARTITIONED;
        this.partitioner = new KeyPartitioner(extractKeyFn, partitioner, this.toDebugString());
        return this;
    }

    @Nonnull
    public Edge allToOne(Object key) {
        return this.partitioned(Functions.wholeItem(), new Single(key));
    }

    @Nonnull
    public Edge broadcast() {
        this.routingPolicy = RoutingPolicy.BROADCAST;
        return this;
    }

    @Nonnull
    public Edge isolated() {
        this.routingPolicy = RoutingPolicy.ISOLATED;
        return this;
    }

    public Partitioner<?> getPartitioner() {
        return this.partitioner;
    }

    @Nonnull
    public RoutingPolicy getRoutingPolicy() {
        return this.routingPolicy;
    }

    public Edge distributed() {
        this.isDistributed = true;
        return this;
    }

    public boolean isDistributed() {
        return this.isDistributed;
    }

    @Nullable
    public EdgeConfig getConfig() {
        return this.config;
    }

    public Edge setConfig(@Nullable EdgeConfig config) {
        this.config = config;
        return this;
    }

    @Nonnull
    public String toString() {
        return this.toDebugString();
    }

    private String toDebugString() {
        StringBuilder b = new StringBuilder();
        if (this.sourceOrdinal == 0 && this.destOrdinal == 0) {
            b.append("between(\"").append(this.sourceName).append("\", \"").append(this.destName).append("\")");
        } else {
            b.append("from(\"").append(this.sourceName).append('\"');
            if (this.sourceOrdinal != 0) {
                b.append(", ").append(this.sourceOrdinal);
            }
            b.append(").to(\"").append(this.destName).append('\"');
            if (this.destOrdinal != 0) {
                b.append(", ").append(this.destOrdinal);
            }
            b.append(')');
        }
        switch (this.getRoutingPolicy()) {
            case UNICAST: {
                break;
            }
            case ISOLATED: {
                b.append(".isolated()");
                break;
            }
            case PARTITIONED: {
                b.append(this.getPartitioner() instanceof Single ? ".allToOne()" : ".partitioned(?)");
                break;
            }
            case BROADCAST: {
                b.append(".broadcast()");
                break;
            }
        }
        if (this.isDistributed()) {
            b.append(".distributed()");
        }
        if (this.getPriority() != 0) {
            b.append(".priority(").append(this.getPriority()).append(')');
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Edge)) return false;
        Edge that = (Edge)obj;
        if (!this.sourceName.equals(that.sourceName)) return false;
        if (!this.destName.equals(that.destName)) return false;
        if (this.sourceOrdinal != that.sourceOrdinal) return false;
        if (this.destOrdinal != that.destOrdinal) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.sourceName, this.destName, this.sourceOrdinal, this.destOrdinal);
    }

    void restoreSourceAndDest(Map<String, Vertex> nameToVertex) {
        this.source = nameToVertex.get(this.sourceName);
        this.destination = nameToVertex.get(this.destName);
        assert (this.source != null) : "Couldn't restore source vertex " + this.sourceName + " from map " + nameToVertex;
        assert (this.destination != null) : "Couldn't restore destination vertex " + this.destName + " from map " + nameToVertex;
    }

    @Override
    public void writeData(@Nonnull ObjectDataOutput out) throws IOException {
        out.writeUTF(this.getSourceName());
        out.writeInt(this.getSourceOrdinal());
        out.writeUTF(this.getDestName());
        out.writeInt(this.getDestOrdinal());
        out.writeInt(this.getPriority());
        out.writeBoolean(this.isDistributed());
        out.writeObject(this.getRoutingPolicy());
        CustomClassLoadedObject.write(out, this.getPartitioner());
        out.writeObject(this.getConfig());
    }

    @Override
    public void readData(@Nonnull ObjectDataInput in) throws IOException {
        this.sourceName = in.readUTF();
        this.sourceOrdinal = in.readInt();
        this.destName = in.readUTF();
        this.destOrdinal = in.readInt();
        this.priority = in.readInt();
        this.isDistributed = in.readBoolean();
        this.routingPolicy = (RoutingPolicy)in.readObject();
        try {
            this.partitioner = (Partitioner)CustomClassLoadedObject.read(in);
        }
        catch (HazelcastSerializationException e) {
            throw new HazelcastSerializationException("Error deserializing edge '" + this.sourceName + "' -> '" + this.destName + "': " + e, e);
        }
        this.config = (EdgeConfig)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return JetDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    private static final class KeyPartitioner<T, K>
    implements Partitioner<T> {
        private static final long serialVersionUID = 1L;
        private final FunctionEx<T, K> keyExtractor;
        private final Partitioner<? super K> partitioner;
        private final String edgeDebugName;

        KeyPartitioner(@Nonnull FunctionEx<T, K> keyExtractor, @Nonnull Partitioner<? super K> partitioner, String edgeDebugName) {
            this.keyExtractor = keyExtractor;
            this.partitioner = partitioner;
            this.edgeDebugName = edgeDebugName;
        }

        @Override
        public void init(DefaultPartitionStrategy strategy) {
            this.partitioner.init(strategy);
        }

        @Override
        public int getPartition(T item, int partitionCount) {
            K key = this.keyExtractor.apply(item);
            if (key == null) {
                throw new JetException("Null key from key extractor, edge: " + this.edgeDebugName);
            }
            return this.partitioner.getPartition(key, partitionCount);
        }
    }

    private static class Single
    implements Partitioner<Object> {
        private static final long serialVersionUID = 1L;
        private final Object key;
        private int partition;

        Single(Object key) {
            this.key = key;
        }

        @Override
        public void init(@Nonnull DefaultPartitionStrategy strategy) {
            this.partition = strategy.getPartition(this.key);
        }

        @Override
        public int getPartition(@Nonnull Object item, int partitionCount) {
            return this.partition;
        }
    }

    public static enum RoutingPolicy implements Serializable
    {
        UNICAST,
        ISOLATED,
        PARTITIONED,
        BROADCAST;

    }
}

