/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionLifecycleListener;
import com.hazelcast.internal.nio.ConnectionType;
import com.hazelcast.internal.nio.IOService;
import com.hazelcast.internal.nio.tcp.TcpIpConnectionErrorHandler;
import com.hazelcast.internal.nio.tcp.TcpIpEndpointManager;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class TcpIpConnection
implements Connection {
    private final Channel channel;
    private final ConcurrentMap attributeMap;
    private final TcpIpEndpointManager endpointManager;
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private final AtomicBoolean binding = new AtomicBoolean();
    private final ILogger logger;
    private final int connectionId;
    private final IOService ioService;
    private Address endPoint;
    private TcpIpConnectionErrorHandler errorHandler;
    private volatile String connectionType = "NONE";
    private volatile ConnectionLifecycleListener lifecycleListener;
    private volatile Throwable closeCause;
    private volatile String closeReason;

    public TcpIpConnection(TcpIpEndpointManager endpointManager, ConnectionLifecycleListener lifecycleListener, int connectionId, Channel channel) {
        this.connectionId = connectionId;
        this.endpointManager = endpointManager;
        this.lifecycleListener = lifecycleListener;
        this.ioService = endpointManager.getNetworkingService().getIoService();
        this.logger = this.ioService.getLoggingService().getLogger(TcpIpConnection.class);
        this.channel = channel;
        this.attributeMap = channel.attributeMap();
        this.attributeMap.put(TcpIpConnection.class, this);
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public String getConnectionType() {
        return this.connectionType;
    }

    @Probe(name="connectionType", unit=ProbeUnit.ENUM)
    private int getType() {
        return ConnectionType.getTypeId(this.connectionType);
    }

    @Override
    public void setConnectionType(String connectionType) {
        Objects.requireNonNull(connectionType);
        if (!this.connectionType.equals("NONE")) {
            return;
        }
        this.connectionType = connectionType;
        if (connectionType.equals("MEMBER")) {
            this.logger.info("Initialized new cluster connection between " + this.channel.localSocketAddress() + " and " + this.channel.remoteSocketAddress());
        }
    }

    @Override
    public TcpIpEndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        return this.channel.socket().getPort();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.channel.remoteSocketAddress();
    }

    @Override
    public boolean isAlive() {
        return this.alive.get();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.channel.lastWriteTimeMillis();
    }

    @Override
    public long lastReadTimeMillis() {
        return this.channel.lastReadTimeMillis();
    }

    @Override
    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public void setErrorHandler(TcpIpConnectionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    @Override
    public boolean isClient() {
        return !this.connectionType.equals("MEMBER");
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.channel.write(frame)) {
            return true;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Connection is closed, won't write packet -> " + frame);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpIpConnection)) {
            return false;
        }
        TcpIpConnection that = (TcpIpConnection)o;
        return this.connectionId == that.getConnectionId();
    }

    public int hashCode() {
        return this.connectionId;
    }

    @Override
    public void close(String reason, Throwable cause) {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        this.logClose();
        try {
            this.channel.close();
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        this.lifecycleListener.onConnectionClose(this, null, false);
        this.ioService.onDisconnect(this.endPoint, cause);
        if (cause != null && this.errorHandler != null) {
            this.errorHandler.onError(cause);
        }
    }

    public boolean setBinding() {
        return this.binding.compareAndSet(false, true);
    }

    private void logClose() {
        Level logLevel = this.resolveLogLevelOnClose();
        if (!this.logger.isLoggable(logLevel)) {
            return;
        }
        String message = this.toString() + " closed. Reason: ";
        message = this.closeReason != null ? message + this.closeReason : (this.closeCause != null ? message + this.closeCause.getClass().getName() + "[" + this.closeCause.getMessage() + "]" : message + "Socket explicitly closed");
        if (Level.FINEST.equals(logLevel)) {
            this.logger.log(logLevel, message, this.closeCause);
        } else if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
            this.logger.log(logLevel, message);
        } else {
            this.logger.log(logLevel, message, this.closeCause);
        }
    }

    private Level resolveLogLevelOnClose() {
        if (!this.ioService.isActive()) {
            return Level.FINEST;
        }
        if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
            if (this.connectionType.equals("REST") || this.connectionType.equals("MEMCACHE")) {
                return Level.FINE;
            }
            return Level.INFO;
        }
        return Level.WARNING;
    }

    @Override
    public Throwable getCloseCause() {
        return this.closeCause;
    }

    @Override
    public String getCloseReason() {
        if (this.closeReason == null) {
            return this.closeCause == null ? null : this.closeCause.getMessage();
        }
        return this.closeReason;
    }

    public String toString() {
        return "Connection[id=" + this.connectionId + ", " + this.channel.localSocketAddress() + "->" + this.channel.remoteSocketAddress() + ", qualifier=" + this.endpointManager.getEndpointQualifier() + ", endpoint=" + this.endPoint + ", alive=" + this.alive + ", connectionType=" + this.connectionType + "]";
    }

    @Override
    public Certificate[] getRemoteCertificates() {
        return this.attributeMap != null ? (Certificate[])this.attributeMap.get(Certificate.class) : null;
    }
}

