/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.impl.util.ProgressState;

public class ProgressTracker {
    private boolean isMadeProgress;
    private boolean isDone = true;

    public void reset() {
        this.isMadeProgress = false;
        this.isDone = true;
    }

    public void madeProgress(boolean isMadeProgress) {
        this.isMadeProgress |= isMadeProgress;
    }

    public void madeProgress() {
        this.madeProgress(true);
    }

    public boolean isMadeProgress() {
        return this.isMadeProgress;
    }

    public void mergeWith(ProgressState state) {
        this.isMadeProgress = this.isMadeProgress || state.isMadeProgress();
        this.isDone = this.isDone && state.isDone();
    }

    public void notDone() {
        this.isDone = false;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public ProgressState toProgressState() {
        return ProgressState.valueOf(this.isMadeProgress, this.isDone);
    }

    public String toString() {
        return this.toProgressState().toString();
    }
}

