/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashSet;

public final class HashSetHook
implements SerializerHook<HashSet> {
    @Override
    public Class<HashSet> getSerializationType() {
        return HashSet.class;
    }

    @Override
    public Serializer createSerializer() {
        return new StreamSerializer<HashSet>(){

            @Override
            public int getTypeId() {
                return -323;
            }

            @Override
            public void destroy() {
            }

            @Override
            public void write(ObjectDataOutput out, HashSet set) throws IOException {
                out.writeInt(set.size());
                for (Object o : set) {
                    out.writeObject(o);
                }
            }

            @Override
            public HashSet read(ObjectDataInput in) throws IOException {
                int length = in.readInt();
                HashSet set = new HashSet();
                for (int i = 0; i < length; ++i) {
                    set.add(in.readObject());
                }
                return set;
            }
        };
    }

    @Override
    public boolean isOverwritable() {
        return true;
    }
}

