/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.core.Member;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.metrics.MetricsCompressor;
import com.hazelcast.jet.impl.metrics.MetricsPublisher;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class JobMetricsPublisher
implements MetricsPublisher {
    private final JobExecutionService jobExecutionService;
    private final String namePrefix;
    private final Map<Long, MetricsCompressor> executionIdToCompressor = new HashMap<Long, MetricsCompressor>();

    JobMetricsPublisher(@Nonnull JobExecutionService jobExecutionService, @Nonnull Member member) {
        Objects.requireNonNull(jobExecutionService, "jobExecutionService");
        Objects.requireNonNull(member, "member");
        this.jobExecutionService = jobExecutionService;
        this.namePrefix = JobMetricsUtil.getMemberPrefix(member);
    }

    @Override
    public void publishLong(String name, long value) {
        MetricsCompressor metricsCompressor = this.getCompressor(name);
        if (metricsCompressor != null) {
            metricsCompressor.addLong(JobMetricsUtil.addPrefixToDescriptor(name, this.namePrefix), value);
        }
    }

    @Override
    public void publishDouble(String name, double value) {
        MetricsCompressor metricsCompressor = this.getCompressor(name);
        if (metricsCompressor != null) {
            metricsCompressor.addDouble(JobMetricsUtil.addPrefixToDescriptor(name, this.namePrefix), value);
        }
    }

    @Override
    public void whenComplete() {
        Set<Map.Entry<Long, MetricsCompressor>> compressorEntries = this.executionIdToCompressor.entrySet();
        Iterator<Map.Entry<Long, MetricsCompressor>> it = compressorEntries.iterator();
        while (it.hasNext()) {
            Map.Entry<Long, MetricsCompressor> entry = it.next();
            MetricsCompressor compressor = entry.getValue();
            if (compressor.count() == 0) {
                it.remove();
            }
            Long executionId = entry.getKey();
            byte[] blob = compressor.getBlobAndReset();
            this.jobExecutionService.updateMetrics(executionId, RawJobMetrics.of(blob));
        }
    }

    @Override
    public String name() {
        return "Job Metrics Publisher";
    }

    private MetricsCompressor getCompressor(String name) {
        Long executionId = JobMetricsUtil.getExecutionIdFromMetricDescriptor(name);
        return executionId == null ? null : this.executionIdToCompressor.computeIfAbsent(executionId, id -> new MetricsCompressor());
    }
}

