/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class VertexDef
implements IdentifiedDataSerializable {
    private int id;
    private List<EdgeDef> inboundEdges = new ArrayList<EdgeDef>();
    private List<EdgeDef> outboundEdges = new ArrayList<EdgeDef>();
    private String name;
    private ProcessorSupplier processorSupplier;
    private int localParallelism;

    VertexDef() {
    }

    VertexDef(int id, String name, ProcessorSupplier processorSupplier, int localParallelism) {
        this.id = id;
        this.name = name;
        this.processorSupplier = processorSupplier;
        this.localParallelism = localParallelism;
    }

    String name() {
        return this.name;
    }

    int localParallelism() {
        return this.localParallelism;
    }

    int vertexId() {
        return this.id;
    }

    void addInboundEdges(List<EdgeDef> edges) {
        this.inboundEdges.addAll(edges);
    }

    void addOutboundEdges(List<EdgeDef> edges) {
        this.outboundEdges.addAll(edges);
    }

    List<EdgeDef> inboundEdges() {
        return this.inboundEdges;
    }

    List<EdgeDef> outboundEdges() {
        return this.outboundEdges;
    }

    ProcessorSupplier processorSupplier() {
        return this.processorSupplier;
    }

    boolean isSnapshotVertex() {
        return this.name.startsWith("__snapshot_");
    }

    boolean isHigherPrioritySource() {
        ArrayDeque<EdgeDef> stack = new ArrayDeque<EdgeDef>();
        stack.addAll(this.outboundEdges);
        while (!stack.isEmpty()) {
            EdgeDef outboundEdge = (EdgeDef)stack.pop();
            VertexDef downstream = outboundEdge.destVertex();
            if (downstream.inboundEdges.stream().anyMatch(edge -> edge.priority() > outboundEdge.priority()) || outboundEdge.isSnapshotRestoreEdge()) {
                return true;
            }
            stack.addAll(downstream.outboundEdges);
        }
        return false;
    }

    public String toString() {
        return "VertexDef{name='" + this.name + '\'' + '}';
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.name);
        ImdgUtil.writeList(out, this.inboundEdges);
        ImdgUtil.writeList(out, this.outboundEdges);
        CustomClassLoadedObject.write(out, this.processorSupplier);
        out.writeInt(this.localParallelism);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readInt();
        this.name = in.readUTF();
        this.inboundEdges = ImdgUtil.readList(in);
        this.outboundEdges = ImdgUtil.readList(in);
        this.processorSupplier = (ProcessorSupplier)CustomClassLoadedObject.read(in);
        this.localParallelism = in.readInt();
    }
}

