/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.exception.JobTerminateRequestedException;
import com.hazelcast.jet.impl.exception.TerminatedWithSnapshotException;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.SnapshotContext;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import com.hazelcast.jet.impl.operation.SnapshotOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class ExecutionContext {
    private final long jobId;
    private final long executionId;
    private final Address coordinator;
    private final Set<Address> participants;
    private final Object executionLock = new Object();
    private final ILogger logger;
    private String jobName;
    private Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap = Collections.emptyMap();
    private Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = Collections.emptyMap();
    private List<ProcessorSupplier> procSuppliers = Collections.emptyList();
    private List<Processor> processors = Collections.emptyList();
    private List<Tasklet> tasklets = Collections.emptyList();
    private volatile CompletableFuture<Void> executionFuture;
    private final CompletableFuture<Void> cancellationFuture = new CompletableFuture();
    private final NodeEngine nodeEngine;
    private final TaskletExecutionService taskletExecService;
    private SnapshotContext snapshotContext;
    private JobConfig jobConfig;
    private volatile RawJobMetrics jobMetrics = RawJobMetrics.empty();

    public ExecutionContext(NodeEngine nodeEngine, TaskletExecutionService taskletExecService, long jobId, long executionId, Address coordinator, Set<Address> participants) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.coordinator = coordinator;
        this.participants = participants;
        this.taskletExecService = taskletExecService;
        this.nodeEngine = nodeEngine;
        this.jobName = Util.idToString(jobId);
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    public ExecutionContext initialize(ExecutionPlan plan) {
        this.jobConfig = plan.getJobConfig();
        this.jobName = this.jobConfig.getName() == null ? this.jobName : this.jobConfig.getName();
        this.procSuppliers = Collections.unmodifiableList(plan.getProcessorSuppliers());
        this.processors = plan.getProcessors();
        this.snapshotContext = new SnapshotContext(this.nodeEngine.getLogger(SnapshotContext.class), this.jobNameAndExecutionId(), plan.lastSnapshotId(), this.jobConfig.getProcessingGuarantee());
        boolean registerMetrics = this.jobConfig.isMetricsEnabled() && ((JetService)this.nodeEngine.getService("hz:impl:jetService")).getMetricsService().isEnabled();
        plan.initialize(this.nodeEngine, this.jobId, this.executionId, this.snapshotContext, registerMetrics);
        this.snapshotContext.initTaskletCount(plan.getStoreSnapshotTaskletCount(), plan.getHigherPriorityVertexCount());
        this.receiverMap = Collections.unmodifiableMap(plan.getReceiverMap());
        this.senderMap = Collections.unmodifiableMap(plan.getSenderMap());
        this.tasklets = plan.getTasklets();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> beginExecution() {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.executionFuture != null) {
                return this.executionFuture;
            }
            JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
            ClassLoader cl = service.getJobExecutionService().getClassLoader(this.jobConfig, this.jobId);
            this.executionFuture = this.taskletExecService.beginExecute(this.tasklets, this.cancellationFuture, cl).thenApply(res -> {
                if (this.snapshotContext.isTerminalSnapshot()) {
                    throw new TerminatedWithSnapshotException();
                }
                return res;
            });
            return this.executionFuture;
        }
    }

    public void completeExecution(Throwable error) {
        assert (this.executionFuture == null || this.executionFuture.isDone()) : "If execution was begun, then completeExecution() should not be called before execution is done.";
        for (Tasklet tasklet : this.tasklets) {
            try {
                tasklet.close();
            }
            catch (Throwable e) {
                this.logger.severe(this.jobNameAndExecutionId() + " encountered an exception in Processor.close(), ignoring it", e);
            }
        }
        for (ProcessorSupplier s : this.procSuppliers) {
            try {
                s.close(error);
            }
            catch (Throwable e) {
                this.logger.severe(this.jobNameAndExecutionId() + " encountered an exception in ProcessorSupplier.complete(), ignoring it", e);
            }
        }
        MetricsRegistry metricsRegistry = ((NodeEngineImpl)this.nodeEngine).getMetricsRegistry();
        this.processors.forEach(metricsRegistry::deregister);
        this.tasklets.forEach(metricsRegistry::deregister);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> terminateExecution(@Nullable TerminationMode mode) {
        assert (mode == null || !mode.isWithTerminalSnapshot()) : "terminating with a mode that should do a terminal snapshot";
        Object object = this.executionLock;
        synchronized (object) {
            if (mode == null) {
                this.cancellationFuture.cancel(true);
            } else {
                this.cancellationFuture.completeExceptionally(new JobTerminateRequestedException(mode));
            }
            if (this.executionFuture == null) {
                this.executionFuture = this.cancellationFuture;
            }
            this.snapshotContext.cancel();
            return this.executionFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<SnapshotOperation.SnapshotOperationResult> beginSnapshot(long snapshotId, String mapName, boolean isTerminal) {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.cancellationFuture.isDone()) {
                throw new CancellationException();
            }
            if (this.executionFuture != null && this.executionFuture.isDone()) {
                return CompletableFuture.completedFuture(new SnapshotOperation.SnapshotOperationResult(0L, 0L, 0L, null));
            }
            return this.snapshotContext.startNewSnapshot(snapshotId, mapName, isTerminal);
        }
    }

    public void handlePacket(int vertexId, int ordinal, Address sender, BufferObjectDataInput in) {
        this.receiverMap.get(vertexId).get(ordinal).get(sender).receiveStreamPacket(in);
    }

    public boolean hasParticipant(Address member) {
        return this.participants.contains(member);
    }

    public long jobId() {
        return this.jobId;
    }

    public long executionId() {
        return this.executionId;
    }

    public String jobNameAndExecutionId() {
        return com.hazelcast.jet.impl.util.Util.jobNameAndExecutionId(this.jobName, this.executionId);
    }

    public Address coordinator() {
        return this.coordinator;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap() {
        return this.senderMap;
    }

    public Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap() {
        return this.receiverMap;
    }

    @Nullable
    public String jobName() {
        return this.jobName;
    }

    public RawJobMetrics getJobMetrics() {
        return this.jobMetrics;
    }

    public void setJobMetrics(RawJobMetrics jobMetrics) {
        this.jobMetrics = jobMetrics;
    }
}

