/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.yaml.W3cDomUtil;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.internal.yaml.YamlScalar;
import com.hazelcast.internal.yaml.YamlUtil;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.impl.config.JetDomConfigProcessor;
import java.util.Properties;
import org.w3c.dom.Node;

public class YamlJetDomConfigProcessor
extends JetDomConfigProcessor {
    protected YamlJetDomConfigProcessor(boolean domLevel3, JetConfig config) {
        super(domLevel3, config);
    }

    @Override
    protected void parseMetrics(Node node, JetConfig config) {
        MetricsConfig metricsConfig = config.getMetricsConfig();
        for (Node metricsNode : DomConfigHelper.childElements(node)) {
            if (metricsNode.getNodeName().equals("enabled")) {
                metricsConfig.setEnabled(DomConfigHelper.getBooleanValue(metricsNode.getNodeValue()));
            }
            if (!metricsNode.getNodeName().equals("jmx-enabled")) continue;
            metricsConfig.setJmxEnabled(DomConfigHelper.getBooleanValue(metricsNode.getNodeValue()));
        }
        this.handleMetricsNode(node, metricsConfig);
    }

    @Override
    protected void fillProperties(Node node, Properties properties) {
        YamlMapping propertiesMapping = W3cDomUtil.getWrappedYamlMapping(node);
        for (YamlNode propNode : propertiesMapping.children()) {
            YamlScalar propScalar = YamlUtil.asScalar(propNode);
            String key = propScalar.nodeName();
            String value = propScalar.nodeValue().toString();
            properties.put(key, value);
        }
    }
}

