/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.Util;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class TopologicalSorter<V> {
    private final Map<TarjanVertex<V>, List<TarjanVertex<V>>> adjacencyMap;
    private final Function<V, String> vertexNameFn;
    private final ArrayDeque<V> topologicallySorted = new ArrayDeque();
    private final Deque<TarjanVertex<V>> tarjanStack = new ArrayDeque<TarjanVertex<V>>();
    private int nextIndex;

    private TopologicalSorter(@Nonnull Map<TarjanVertex<V>, List<TarjanVertex<V>>> adjacencyMap, @Nonnull Function<V, String> vertexNameFn) {
        this.adjacencyMap = adjacencyMap;
        this.vertexNameFn = vertexNameFn;
    }

    public static <V> Iterable<V> topologicalSort(@Nonnull Map<V, List<V>> adjacencyMap, @Nonnull Function<V, String> vertexNameFn) {
        Map<Object, TarjanVertex> tarjanVertices = adjacencyMap.keySet().stream().map(v -> Util.entry(v, new TarjanVertex<Object>(v))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<TarjanVertex<V>, List<TarjanVertex<V>>> tarjanAdjacencyMap = adjacencyMap.entrySet().stream().collect(Collectors.toMap(e -> (TarjanVertex)tarjanVertices.get(e.getKey()), e -> ((List)e.getValue()).stream().map(tarjanVertices::get).collect(Collectors.toList())));
        return super.go();
    }

    public static <V> void checkTopologicalSort(Iterable<Map.Entry<V, List<V>>> adjacencyMap) {
        HashSet<V> seen = new HashSet<V>();
        for (Map.Entry<V, List<V>> parentAndChildren : adjacencyMap) {
            for (V child : parentAndChildren.getValue()) {
                if (!seen.contains(child)) continue;
                throw new RuntimeException("A child seen before its parent");
            }
            seen.add(parentAndChildren.getKey());
        }
    }

    private Iterable<V> go() {
        for (TarjanVertex<V> tv : this.adjacencyMap.keySet()) {
            if (tv.index != -1) continue;
            assert (this.tarjanStack.isEmpty()) : "Broken stack invariant";
            this.strongConnect(tv);
        }
        return this.topologicallySorted;
    }

    private void strongConnect(TarjanVertex<V> currTv) {
        currTv.visitedAtIndex(this.nextIndex++);
        this.push(currTv);
        for (TarjanVertex<V> outTv : this.adjacencyMap.get(currTv)) {
            if (outTv == currTv) {
                throw new IllegalArgumentException("Vertex " + this.vertexNameFn.apply(currTv.v) + " is connected to itself");
            }
            if (outTv.index == -1) {
                this.strongConnect(outTv);
                currTv.lowlink = Math.min(currTv.lowlink, outTv.lowlink);
                continue;
            }
            if (!outTv.onStack) continue;
            currTv.lowlink = Math.min(currTv.lowlink, outTv.index);
        }
        if (currTv.lowlink < currTv.index) {
            return;
        }
        assert (currTv.lowlink == currTv.index) : "Broken lowlink invariant";
        TarjanVertex<V> popped = this.pop();
        if (popped == currTv) {
            this.topologicallySorted.addFirst(currTv.v);
            return;
        }
        while (this.tarjanStack.peekFirst() != currTv) {
            this.tarjanStack.removeFirst();
        }
        this.tarjanStack.addLast(popped);
        this.tarjanStack.addLast(currTv);
        throw new IllegalArgumentException("DAG contains a cycle: " + this.tarjanStack.stream().map(av -> this.vertexNameFn.apply(av.v)).collect(Collectors.joining(" -> ")));
    }

    private void push(TarjanVertex<V> thisTv) {
        thisTv.onStack = true;
        this.tarjanStack.addLast(thisTv);
    }

    private TarjanVertex<V> pop() {
        TarjanVertex<V> popped = this.tarjanStack.removeLast();
        popped.onStack = false;
        return popped;
    }

    private static final class TarjanVertex<V> {
        V v;
        int index = -1;
        int lowlink = -1;
        boolean onStack;

        TarjanVertex(@Nonnull V v) {
            this.v = v;
        }

        void visitedAtIndex(int index) {
            this.index = index;
            this.lowlink = index;
        }

        public String toString() {
            return this.v.toString();
        }
    }
}

