/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.Endpoint;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.core.MigrationListener;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;

public class MigrationWatcher {
    private final HazelcastInstance instance;
    private final String membershipListenerReg;
    private final String migrationListenerReg;
    private final AtomicInteger changeCount = new AtomicInteger();

    public MigrationWatcher(HazelcastInstance instance) {
        this.instance = instance;
        this.migrationListenerReg = this.registerMigrationListener(instance);
        this.membershipListenerReg = this.registerMembershipListener(instance);
    }

    public BooleanSupplier createWatcher() {
        int startChangeCount = this.changeCount.get();
        return () -> this.changeCount.get() != startChangeCount;
    }

    public void deregister() {
        this.instance.getCluster().removeMembershipListener(this.membershipListenerReg);
        if (this.migrationListenerReg != null) {
            this.instance.getPartitionService().removeMigrationListener(this.migrationListenerReg);
        }
    }

    private String registerMembershipListener(final HazelcastInstance instance) {
        return instance.getCluster().addMembershipListener(new MembershipListener(){

            @Override
            public void memberAdded(MembershipEvent event) {
                Endpoint endpoint = instance.getLocalEndpoint();
                if (endpoint != null && endpoint.getUuid() != null && endpoint.getUuid().equals(event.getMember().getUuid())) {
                    return;
                }
                MigrationWatcher.this.changeCount.incrementAndGet();
            }

            @Override
            public void memberRemoved(MembershipEvent membershipEvent) {
                MigrationWatcher.this.changeCount.incrementAndGet();
            }

            @Override
            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
    }

    private String registerMigrationListener(HazelcastInstance instance) {
        try {
            return instance.getPartitionService().addMigrationListener(new MigrationListener(){

                @Override
                public void migrationStarted(MigrationEvent migrationEvent) {
                    MigrationWatcher.this.changeCount.incrementAndGet();
                }

                @Override
                public void migrationCompleted(MigrationEvent migrationEvent) {
                    MigrationWatcher.this.changeCount.incrementAndGet();
                }

                @Override
                public void migrationFailed(MigrationEvent migrationEvent) {
                    MigrationWatcher.this.changeCount.incrementAndGet();
                }
            });
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

