/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.processor.ProcessorSupplierWithContext;
import com.hazelcast.jet.pipeline.ContextFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TransformUsingContextP<C, T, R>
extends AbstractProcessor {
    C contextObject;
    private final ContextFactory<C> contextFactory;
    private final TriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn;
    private Traverser<? extends R> outputTraverser;
    private final ResettableSingletonTraverser<R> singletonTraverser = new ResettableSingletonTraverser();

    private TransformUsingContextP(@Nonnull ContextFactory<C> contextFactory, @Nullable C contextObject, @Nonnull TriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        this.contextFactory = contextFactory;
        this.flatMapFn = flatMapFn;
        this.contextObject = contextObject;
        assert (contextObject == null ^ contextFactory.hasLocalSharing()) : "if contextObject is shared, it must be non-null, or vice versa";
    }

    @Override
    public boolean isCooperative() {
        return this.contextFactory.isCooperative();
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        if (!this.contextFactory.hasLocalSharing()) {
            assert (this.contextObject == null) : "contextObject is not null: " + this.contextObject;
            this.contextObject = this.contextFactory.createFn().apply(context.jetInstance());
        }
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        if (this.outputTraverser == null) {
            this.outputTraverser = this.flatMapFn.apply(this.singletonTraverser, this.contextObject, item);
        }
        if (this.emitFromTraverser(this.outputTraverser)) {
            this.outputTraverser = null;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.contextObject != null && !this.contextFactory.hasLocalSharing()) {
            this.contextFactory.destroyFn().accept(this.contextObject);
        }
        this.contextObject = null;
    }

    public static <C, T, R> ProcessorSupplier supplier(@Nonnull ContextFactory<C> contextFactory, @Nonnull TriFunction<ResettableSingletonTraverser<R>, ? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return ProcessorSupplierWithContext.supplierWithContext(contextFactory, (ctxF, ctxO) -> new TransformUsingContextP((ContextFactory<Object>)ctxF, ctxO, flatMapFn));
    }
}

