/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.core.Member;
import com.hazelcast.internal.metrics.renderers.ProbeRenderer;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.metrics.MetricsCompressor;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CompleteExecutionOperation
extends Operation
implements IdentifiedDataSerializable {
    private long executionId;
    private boolean collectMetrics;
    private Throwable error;
    private RawJobMetrics response;

    public CompleteExecutionOperation() {
    }

    public CompleteExecutionOperation(long executionId, boolean collectMetrics, Throwable error) {
        this.executionId = executionId;
        this.collectMetrics = collectMetrics;
        this.error = error;
    }

    @Override
    public void run() {
        ILogger logger = this.getLogger();
        JetService service = (JetService)this.getService();
        Address callerAddress = this.getCallerAddress();
        logger.fine("Completing execution " + Util.idToString(this.executionId) + " from caller " + callerAddress + ", error=" + this.error);
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!callerAddress.equals(masterAddress)) {
            throw new IllegalStateException("Caller " + callerAddress + " cannot complete execution " + Util.idToString(this.executionId) + " because it is not master. Master is: " + masterAddress);
        }
        JobExecutionService jobExecutionService = service.getJobExecutionService();
        if (this.collectMetrics) {
            JobMetricsRenderer metricsRenderer = new JobMetricsRenderer(this.executionId, nodeEngine.getLocalMember(), logger);
            nodeEngine.getMetricsRegistry().render(metricsRenderer);
            metricsRenderer.whenComplete();
            this.response = metricsRenderer.getJobMetrics();
        } else {
            this.response = RawJobMetrics.empty();
        }
        jobExecutionService.completeExecution(this.executionId, this.error);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeBoolean(this.collectMetrics);
        out.writeObject(this.error);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.collectMetrics = in.readBoolean();
        this.error = (Throwable)in.readObject();
    }

    private static class JobMetricsRenderer
    implements ProbeRenderer {
        private final Long executionIdOfInterest;
        private final String namePrefix;
        private final MetricsCompressor compressor;
        private final ILogger logger;
        private RawJobMetrics jobMetrics = RawJobMetrics.empty();

        JobMetricsRenderer(long executionId, @Nonnull Member member, @Nonnull ILogger logger) {
            Objects.requireNonNull(member, "member");
            this.logger = Objects.requireNonNull(logger, "logger");
            this.executionIdOfInterest = executionId;
            this.namePrefix = JobMetricsUtil.getMemberPrefix(member);
            this.compressor = new MetricsCompressor();
        }

        @Override
        public void renderLong(String name, long value) {
            Long executionId = JobMetricsUtil.getExecutionIdFromMetricDescriptor(name);
            if (this.executionIdOfInterest.equals(executionId)) {
                String prefixedName = JobMetricsUtil.addPrefixToDescriptor(name, this.namePrefix);
                this.compressor.addLong(prefixedName, value);
            }
        }

        @Override
        public void renderDouble(String name, double value) {
            Long executionId = JobMetricsUtil.getExecutionIdFromMetricDescriptor(name);
            if (this.executionIdOfInterest.equals(executionId)) {
                String prefixedName = JobMetricsUtil.addPrefixToDescriptor(name, this.namePrefix);
                this.compressor.addDouble(prefixedName, value);
            }
        }

        @Override
        public void renderException(String name, Exception e) {
            Long executionId = JobMetricsUtil.getExecutionIdFromMetricDescriptor(name);
            if (this.executionIdOfInterest.equals(executionId)) {
                this.logger.warning("Exception when rendering job metrics: " + e, e);
            }
        }

        @Override
        public void renderNoValue(String name) {
        }

        public void whenComplete() {
            this.jobMetrics = RawJobMetrics.of(this.compressor.getBlobAndReset());
        }

        @Nonnull
        RawJobMetrics getJobMetrics() {
            return this.jobMetrics;
        }
    }
}

