/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.util.ImdgUtil;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class ReadIListP
extends AbstractProcessor {
    static final int FETCH_SIZE = 16384;
    private final String name;
    private final String clientXml;
    private Traverser<Object> traverser;
    private HazelcastInstance client;

    ReadIListP(String name, String clientXml) {
        this.name = name;
        this.clientXml = clientXml;
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        HazelcastInstance instance = this.isRemote() ? (this.client = HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(this.clientXml))) : context.jetInstance().getHazelcastInstance();
        IList list = instance.getList(this.name);
        int size = list.size();
        this.traverser = size <= 16384 ? Traversers.traverseIterable(list) : Traversers.traverseStream(IntStream.rangeClosed(0, size / 16384).mapToObj(chunkIndex -> chunkIndex * 16384)).flatMap(start -> Traversers.traverseIterable(list.subList((int)start, Math.min(start + 16384, size))));
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.traverser);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private boolean isRemote() {
        return this.clientXml != null;
    }
}

