/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.cache.impl.journal.CacheEventJournalFunctions;
import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.map.impl.journal.MapEventJournalFunctions;
import com.hazelcast.map.journal.EventJournalMapEvent;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

public final class Util {
    private static final char[] ID_TEMPLATE = "0000-0000-0000-0000".toCharArray();
    private static final Pattern ID_PATTERN = Pattern.compile("(\\p{XDigit}{4}-){3}\\p{XDigit}{4}");

    private Util() {
    }

    public static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    public static <K, V> PredicateEx<EventJournalMapEvent<K, V>> mapPutEvents() {
        return ImdgUtil.wrapImdgPredicate(MapEventJournalFunctions.mapPutEvents());
    }

    public static <K, V> PredicateEx<EventJournalCacheEvent<K, V>> cachePutEvents() {
        return ImdgUtil.wrapImdgPredicate(CacheEventJournalFunctions.cachePutEvents());
    }

    public static <K, V> FunctionEx<EventJournalMapEvent<K, V>, Map.Entry<K, V>> mapEventToEntry() {
        return ImdgUtil.wrapImdgFunction(MapEventJournalFunctions.mapEventToEntry());
    }

    public static <K, V> FunctionEx<EventJournalMapEvent<K, V>, V> mapEventNewValue() {
        return ImdgUtil.wrapImdgFunction(MapEventJournalFunctions.mapEventNewValue());
    }

    public static <K, V> FunctionEx<EventJournalCacheEvent<K, V>, Map.Entry<K, V>> cacheEventToEntry() {
        return ImdgUtil.wrapImdgFunction(CacheEventJournalFunctions.cacheEventToEntry());
    }

    public static <K, V> FunctionEx<EventJournalCacheEvent<K, V>, V> cacheEventNewValue() {
        return ImdgUtil.wrapImdgFunction(CacheEventJournalFunctions.cacheEventNewValue());
    }

    public static String idToString(long id) {
        char[] buf = Arrays.copyOf(ID_TEMPLATE, ID_TEMPLATE.length);
        String hexStr = Long.toHexString(id);
        int i = hexStr.length() - 1;
        int j = 18;
        while (i >= 0) {
            buf[j] = hexStr.charAt(i);
            if (j == 15 || j == 10 || j == 5) {
                --j;
            }
            --i;
            --j;
        }
        return new String(buf);
    }

    public static long idFromString(String str) {
        if (str == null || !ID_PATTERN.matcher(str).matches()) {
            return -1L;
        }
        str = str.replaceAll("-", "");
        return Long.parseUnsignedLong(str, 16);
    }

    public static <T> CompletableFuture<T> toCompletableFuture(ICompletableFuture<T> future) {
        final CompletableFuture f = new CompletableFuture();
        future.andThen(new ExecutionCallback<T>(){

            @Override
            public void onResponse(T response) {
                f.complete(response);
            }

            @Override
            public void onFailure(Throwable t) {
                f.completeExceptionally(t);
            }
        });
        return f;
    }
}

