 package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Bits;

/**
 * @since 1.0
 * update 1.0
 */
@edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetReadMetricsCodec {

    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_READMETRICS;
    public static final int RESPONSE_TYPE = 105;

    //************************ REQUEST *************************//

    public static class RequestParameters {
    public static final JetMessageType TYPE = REQUEST_TYPE;

         /**
         * @since 1.0
         */
        public java.lang.String uuid;
        public long fromSequence;

         /**
         * @since 1.0
         */
        public static int calculateDataSize(java.lang.String uuid, long fromSequence) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(uuid);
            dataSize += Bits.LONG_SIZE_IN_BYTES;
            return dataSize;
        }
    }

         /**
         * @since 1.0
         */
        public static ClientMessage encodeRequest(java.lang.String uuid, long fromSequence) {
            final int requiredDataSize = RequestParameters.calculateDataSize(uuid, fromSequence);
            ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
            clientMessage.setMessageType(REQUEST_TYPE.id());
            clientMessage.setRetryable(true);
            clientMessage.setAcquiresResource(false);
            clientMessage.setOperationName("Jet.readMetrics");
        clientMessage.set(uuid);
        clientMessage.set(fromSequence);
            clientMessage.updateFrameLength();
            return clientMessage;
        }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        final RequestParameters parameters = new RequestParameters();
        java.lang.String uuid = null
;
        uuid = clientMessage.getStringUtf8();
            parameters.uuid = uuid;
    
        long fromSequence = 0
;
        fromSequence = clientMessage.getLong();
            parameters.fromSequence = fromSequence;
    
        return parameters;
    }

    //************************ RESPONSE *************************//

    public static class ResponseParameters {
         /**
         * @since 1.0
         */
        public com.hazelcast.nio.serialization.Data response;

         /**
         * @since 1.0
         */
        public static int calculateDataSize( com.hazelcast.nio.serialization.Data response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += Bits.BOOLEAN_SIZE_IN_BYTES;
            if (response != null) {
            dataSize += ParameterUtil.calculateDataSize(response);
            }
            return dataSize;
        }
    }

    /**
    * @since 1.0
    */
    public static ClientMessage encodeResponse(com.hazelcast.nio.serialization.Data response) {
        final int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(RESPONSE_TYPE);
        boolean response_isNull;
        if (response == null) {
            response_isNull = true;
            clientMessage.set(response_isNull);
        } else {
            response_isNull= false;
            clientMessage.set(response_isNull);
        clientMessage.set(response);
        }
        clientMessage.updateFrameLength();
        return clientMessage;

    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        com.hazelcast.nio.serialization.Data response = null
;
        boolean response_isNull = clientMessage.getBoolean();
        if (!response_isNull) {
        response = clientMessage.getData();
            parameters.response = response;
        }
    
        return parameters;
    }

}
