 package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Bits;

/**
 * @since 1.0
 * update 1.0
 */
@edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetGetMemberXmlConfigurationCodec {

    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_GETMEMBERXMLCONFIGURATION;
    public static final int RESPONSE_TYPE = 104;

    //************************ REQUEST *************************//

    public static class RequestParameters {
    public static final JetMessageType TYPE = REQUEST_TYPE;

         /**
         * @since 1.0
         */

         /**
         * @since 1.0
         */
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

         /**
         * @since 1.0
         */
        public static ClientMessage encodeRequest() {
            final int requiredDataSize = RequestParameters.calculateDataSize();
            ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
            clientMessage.setMessageType(REQUEST_TYPE.id());
            clientMessage.setRetryable(true);
            clientMessage.setAcquiresResource(false);
            clientMessage.setOperationName("Jet.getMemberXmlConfiguration");
            clientMessage.updateFrameLength();
            return clientMessage;
        }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        final RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    //************************ RESPONSE *************************//

    public static class ResponseParameters {
         /**
         * @since 1.0
         */
        public java.lang.String response;

         /**
         * @since 1.0
         */
        public static int calculateDataSize( java.lang.String response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(response);
            return dataSize;
        }
    }

    /**
    * @since 1.0
    */
    public static ClientMessage encodeResponse(java.lang.String response) {
        final int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(RESPONSE_TYPE);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;

    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        java.lang.String response = null
;
        response = clientMessage.getStringUtf8();
            parameters.response = response;
    
        return parameters;
    }

}
