 package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Bits;

/**
 * @since 1.0
 * update 1.0
 */
@edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetGetClusterMetadataCodec {

    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_GETCLUSTERMETADATA;
    public static final int RESPONSE_TYPE = 131;

    //************************ REQUEST *************************//

    public static class RequestParameters {
    public static final JetMessageType TYPE = REQUEST_TYPE;

         /**
         * @since 1.0
         */

         /**
         * @since 1.0
         */
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

         /**
         * @since 1.0
         */
        public static ClientMessage encodeRequest() {
            final int requiredDataSize = RequestParameters.calculateDataSize();
            ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
            clientMessage.setMessageType(REQUEST_TYPE.id());
            clientMessage.setRetryable(true);
            clientMessage.setAcquiresResource(false);
            clientMessage.setOperationName("Jet.getClusterMetadata");
            clientMessage.updateFrameLength();
            return clientMessage;
        }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        final RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    //************************ RESPONSE *************************//

    public static class ResponseParameters {
         /**
         * @since 1.0
         */
        public java.lang.String name;
        public java.lang.String version;
        public long clusterTime;
        public int state;

         /**
         * @since 1.0
         */
        public static int calculateDataSize( java.lang.String name,  java.lang.String version,  long clusterTime,  int state) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(version);
            dataSize += Bits.LONG_SIZE_IN_BYTES;
            dataSize += Bits.INT_SIZE_IN_BYTES;
            return dataSize;
        }
    }

    /**
    * @since 1.0
    */
    public static ClientMessage encodeResponse(java.lang.String name, java.lang.String version, long clusterTime, int state) {
        final int requiredDataSize = ResponseParameters.calculateDataSize(name, version, clusterTime, state);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(RESPONSE_TYPE);
        clientMessage.set(name);
        clientMessage.set(version);
        clientMessage.set(clusterTime);
        clientMessage.set(state);
        clientMessage.updateFrameLength();
        return clientMessage;

    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        java.lang.String name = null
;
        name = clientMessage.getStringUtf8();
            parameters.name = name;
    
        java.lang.String version = null
;
        version = clientMessage.getStringUtf8();
            parameters.version = version;
    
        long clusterTime = 0
;
        clusterTime = clientMessage.getLong();
            parameters.clusterTime = clusterTime;
    
        int state = 0
;
        state = clientMessage.getInt();
            parameters.state = state;
    
        return parameters;
    }

}
