 package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Bits;

/**
 * @since 1.0
 * update 1.0
 */
@edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetExistsDistributedObjectCodec {

    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_EXISTSDISTRIBUTEDOBJECT;
    public static final int RESPONSE_TYPE = 101;

    //************************ REQUEST *************************//

    public static class RequestParameters {
    public static final JetMessageType TYPE = REQUEST_TYPE;

         /**
         * @since 1.0
         */
        public java.lang.String serviceName;
        public java.lang.String objectName;

         /**
         * @since 1.0
         */
        public static int calculateDataSize(java.lang.String serviceName, java.lang.String objectName) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(serviceName);
            dataSize += ParameterUtil.calculateDataSize(objectName);
            return dataSize;
        }
    }

         /**
         * @since 1.0
         */
        public static ClientMessage encodeRequest(java.lang.String serviceName, java.lang.String objectName) {
            final int requiredDataSize = RequestParameters.calculateDataSize(serviceName, objectName);
            ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
            clientMessage.setMessageType(REQUEST_TYPE.id());
            clientMessage.setRetryable(true);
            clientMessage.setAcquiresResource(false);
            clientMessage.setOperationName("Jet.existsDistributedObject");
        clientMessage.set(serviceName);
        clientMessage.set(objectName);
            clientMessage.updateFrameLength();
            return clientMessage;
        }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        final RequestParameters parameters = new RequestParameters();
        java.lang.String serviceName = null
;
        serviceName = clientMessage.getStringUtf8();
            parameters.serviceName = serviceName;
    
        java.lang.String objectName = null
;
        objectName = clientMessage.getStringUtf8();
            parameters.objectName = objectName;
    
        return parameters;
    }

    //************************ RESPONSE *************************//

    public static class ResponseParameters {
         /**
         * @since 1.0
         */
        public boolean response;

         /**
         * @since 1.0
         */
        public static int calculateDataSize( boolean response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += Bits.BOOLEAN_SIZE_IN_BYTES;
            return dataSize;
        }
    }

    /**
    * @since 1.0
    */
    public static ClientMessage encodeResponse(boolean response) {
        final int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(RESPONSE_TYPE);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;

    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        boolean response = false
;
        response = clientMessage.getBoolean();
            parameters.response = response;
    
        return parameters;
    }

}
