/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.ProbeBuilder;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.OneToOneConcurrentArrayQueue;
import com.hazelcast.internal.util.concurrent.QueuedPipe;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ConcurrentInboundEdgeStream;
import com.hazelcast.jet.impl.execution.ConveyorCollector;
import com.hazelcast.jet.impl.execution.ConveyorCollectorWithPartition;
import com.hazelcast.jet.impl.execution.InboundEdgeStream;
import com.hazelcast.jet.impl.execution.OutboundCollector;
import com.hazelcast.jet.impl.execution.OutboundEdgeStream;
import com.hazelcast.jet.impl.execution.ProcessorTasklet;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.SnapshotContext;
import com.hazelcast.jet.impl.execution.StoreSnapshotTasklet;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.execution.init.PartitionArrangement;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import com.hazelcast.jet.impl.util.AsyncSnapshotWriterImpl;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class ExecutionPlan
implements IdentifiedDataSerializable {
    private static final int SNAPSHOT_QUEUE_SIZE = 1024;
    private final List<Tasklet> tasklets = new ArrayList<Tasklet>();
    private final Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap = new HashMap<Integer, Map<Integer, Map<Address, ReceiverTasklet>>>();
    private final Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = new HashMap<Integer, Map<Integer, Map<Address, SenderTasklet>>>();
    private Address[] partitionOwners;
    private JobConfig jobConfig;
    private List<VertexDef> vertices = new ArrayList<VertexDef>();
    private int memberIndex;
    private int memberCount;
    private final Map<String, ConcurrentConveyor<Object>[]> localConveyorMap = new HashMap<String, ConcurrentConveyor<Object>[]>();
    private final Map<String, Map<Address, ConcurrentConveyor<Object>>> edgeSenderConveyorMap = new HashMap<String, Map<Address, ConcurrentConveyor<Object>>>();
    private final List<Processor> processors = new ArrayList<Processor>();
    private PartitionArrangement ptionArrgmt;
    private NodeEngineImpl nodeEngine;
    private long executionId;
    private long lastSnapshotId;
    private final Supplier<Set<Address>> remoteMembers = com.hazelcast.jet.impl.util.Util.memoize(() -> Arrays.stream(this.partitionOwners).filter(a -> !a.equals(this.nodeEngine.getThisAddress())).collect(Collectors.toSet()));

    ExecutionPlan() {
    }

    ExecutionPlan(Address[] partitionOwners, JobConfig jobConfig, long lastSnapshotId, int memberIndex, int memberCount) {
        this.partitionOwners = partitionOwners;
        this.jobConfig = jobConfig;
        this.lastSnapshotId = lastSnapshotId;
        this.memberIndex = memberIndex;
        this.memberCount = memberCount;
    }

    public void initialize(NodeEngine nodeEngine, long jobId, long executionId, SnapshotContext snapshotContext, boolean registerMetrics) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.executionId = executionId;
        this.initProcSuppliers(jobId, executionId);
        this.initDag();
        this.ptionArrgmt = new PartitionArrangement(this.partitionOwners, nodeEngine.getThisAddress());
        JetInstance instance = com.hazelcast.jet.impl.util.Util.getJetInstance(nodeEngine);
        Set<Integer> higherPriorityVertices = VertexDef.getHigherPriorityVertices(this.vertices);
        for (VertexDef vertex : this.vertices) {
            Collection<? extends Processor> processors = ExecutionPlan.createProcessors(vertex, vertex.localParallelism());
            QueuedPipe[] snapshotQueues = new QueuedPipe[vertex.localParallelism()];
            Arrays.setAll(snapshotQueues, i -> new OneToOneConcurrentArrayQueue(1024));
            ConcurrentConveyor<Object> ssConveyor = ConcurrentConveyor.concurrentConveyor(null, snapshotQueues);
            StoreSnapshotTasklet ssTasklet = new StoreSnapshotTasklet(snapshotContext, new ConcurrentInboundEdgeStream(ssConveyor, 0, 0, true, "ssFrom:" + vertex.name()), new AsyncSnapshotWriterImpl(nodeEngine, snapshotContext, vertex.name(), this.memberIndex, this.memberCount), nodeEngine.getLogger(StoreSnapshotTasklet.class.getName() + "." + com.hazelcast.jet.impl.util.Util.sanitizeLoggerNamePart(vertex.name())), vertex.name(), higherPriorityVertices.contains(vertex.vertexId()));
            this.tasklets.add(ssTasklet);
            int localProcessorIdx = 0;
            for (Processor processor : processors) {
                int globalProcessorIndex = this.memberIndex * vertex.localParallelism() + localProcessorIdx;
                String loggerName = ExecutionPlan.createLoggerName(processor.getClass().getName(), this.jobConfig.getName(), vertex.name(), globalProcessorIndex);
                Contexts.ProcCtx context = new Contexts.ProcCtx(instance, jobId, executionId, this.getJobConfig(), nodeEngine.getLogger(loggerName), vertex.name(), localProcessorIdx, globalProcessorIndex, this.jobConfig.getProcessingGuarantee(), vertex.localParallelism(), this.memberIndex, this.memberCount);
                ProbeBuilder probeBuilder = null;
                ProbeBuilder processorProbeBuilder = null;
                if (registerMetrics) {
                    probeBuilder = this.nodeEngine.getMetricsRegistry().newProbeBuilder().withTag("module", "jet").withTag("job", Util.idToString(jobId)).withTag("exec", Util.idToString(executionId)).withTag("vertex", vertex.name());
                    if (vertex.inboundEdges().stream().allMatch(EdgeDef::isSnapshotRestoreEdge) && !vertex.isSnapshotVertex()) {
                        probeBuilder = probeBuilder.withTag("source", "true");
                    }
                    if (vertex.outboundEdges().size() == 0) {
                        probeBuilder = probeBuilder.withTag("sink", "true");
                    }
                    processorProbeBuilder = probeBuilder.withTag("proc", String.valueOf(globalProcessorIndex));
                    processorProbeBuilder.withTag("procType", processor.getClass().getSimpleName()).scanAndRegister(processor);
                }
                List<OutboundEdgeStream> outboundStreams = this.createOutboundEdgeStreams(vertex, localProcessorIdx, probeBuilder);
                List<InboundEdgeStream> inboundStreams = this.createInboundEdgeStreams(vertex, localProcessorIdx, globalProcessorIndex);
                ConveyorCollector snapshotCollector = new ConveyorCollector(ssConveyor, localProcessorIdx, null);
                ProcessorTasklet processorTasklet = new ProcessorTasklet(context, nodeEngine.getSerializationService(), processor, inboundStreams, outboundStreams, snapshotContext, snapshotCollector, processorProbeBuilder);
                this.tasklets.add(processorTasklet);
                this.processors.add(processor);
                ++localProcessorIdx;
            }
        }
        List allReceivers = this.receiverMap.values().stream().flatMap(o -> o.values().stream()).flatMap(a -> a.values().stream()).collect(Collectors.toList());
        this.tasklets.addAll(allReceivers);
    }

    public static String createLoggerName(String processorClassName, String jobName, String vertexName, int processorIndex) {
        vertexName = com.hazelcast.jet.impl.util.Util.sanitizeLoggerNamePart(vertexName);
        if (StringUtil.isNullOrEmptyAfterTrim(jobName)) {
            return processorClassName + '.' + vertexName + '#' + processorIndex;
        }
        return processorClassName + '.' + jobName.trim() + "/" + vertexName + '#' + processorIndex;
    }

    public List<ProcessorSupplier> getProcessorSuppliers() {
        return this.vertices.stream().map(VertexDef::processorSupplier).collect(Collectors.toList());
    }

    public Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> getReceiverMap() {
        return this.receiverMap;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> getSenderMap() {
        return this.senderMap;
    }

    public List<Tasklet> getTasklets() {
        return this.tasklets;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    void addVertex(VertexDef vertex) {
        this.vertices.add(vertex);
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        ImdgUtil.writeList(out, this.vertices);
        out.writeInt(this.partitionOwners.length);
        out.writeLong(this.lastSnapshotId);
        for (Address address : this.partitionOwners) {
            out.writeObject(address);
        }
        out.writeObject(this.jobConfig);
        out.writeInt(this.memberIndex);
        out.writeInt(this.memberCount);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.vertices = ImdgUtil.readList(in);
        int len = in.readInt();
        this.partitionOwners = new Address[len];
        this.lastSnapshotId = in.readLong();
        for (int i = 0; i < len; ++i) {
            this.partitionOwners[i] = (Address)in.readObject();
        }
        this.jobConfig = (JobConfig)in.readObject();
        this.memberIndex = in.readInt();
        this.memberCount = in.readInt();
    }

    private void initProcSuppliers(long jobId, long executionId) {
        JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
        for (VertexDef vertex : this.vertices) {
            ProcessorSupplier supplier = vertex.processorSupplier();
            ILogger logger = this.nodeEngine.getLogger(supplier.getClass().getName() + '.' + vertex.name() + "#ProcessorSupplier");
            try {
                supplier.init(new Contexts.ProcSupplierCtx(service.getJetInstance(), jobId, executionId, this.jobConfig, logger, vertex.name(), vertex.localParallelism(), vertex.localParallelism() * this.memberCount, this.memberIndex, this.memberCount, this.jobConfig.getProcessingGuarantee()));
            }
            catch (Exception e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }
    }

    private void initDag() {
        Map<Integer, VertexDef> vMap = this.vertices.stream().collect(Collectors.toMap(VertexDef::vertexId, v -> v));
        for (VertexDef v2 : this.vertices) {
            v2.inboundEdges().forEach(e -> e.initTransientFields(vMap, v2, false));
            v2.outboundEdges().forEach(e -> e.initTransientFields(vMap, v2, true));
        }
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        this.vertices.stream().map(VertexDef::outboundEdges).flatMap(Collection::stream).map(EdgeDef::partitioner).filter(Objects::nonNull).forEach(p -> p.init(partitionService::getPartitionId));
    }

    private static Collection<? extends Processor> createProcessors(VertexDef vertexDef, int parallelism) {
        Collection<? extends Processor> processors = vertexDef.processorSupplier().get(parallelism);
        if (processors.size() != parallelism) {
            throw new JetException("ProcessorSupplier failed to return the requested number of processors. Requested: " + parallelism + ", returned: " + processors.size());
        }
        return processors;
    }

    private List<OutboundEdgeStream> createOutboundEdgeStreams(VertexDef srcVertex, int processorIdx, @Nullable ProbeBuilder probeBuilder) {
        ArrayList<OutboundEdgeStream> outboundStreams = new ArrayList<OutboundEdgeStream>();
        for (EdgeDef edge : srcVertex.outboundEdges()) {
            ProbeBuilder builder = null;
            if (probeBuilder != null) {
                builder = probeBuilder.withTag("ordinal", String.valueOf(edge.sourceOrdinal()));
            }
            Map<Address, ConcurrentConveyor<Object>> memberToSenderConveyorMap = null;
            if (edge.isDistributed()) {
                memberToSenderConveyorMap = this.memberToSenderConveyorMap(this.edgeSenderConveyorMap, edge, builder);
            }
            outboundStreams.add(this.createOutboundEdgeStream(edge, processorIdx, memberToSenderConveyorMap, builder));
        }
        return outboundStreams;
    }

    private Map<Address, ConcurrentConveyor<Object>> memberToSenderConveyorMap(Map<String, Map<Address, ConcurrentConveyor<Object>>> edgeSenderConveyorMap, EdgeDef edge, @Nullable ProbeBuilder probeBuilder) {
        assert (edge.isDistributed()) : "Edge is not distributed";
        return edgeSenderConveyorMap.computeIfAbsent(edge.edgeId(), x -> {
            HashMap<Address, ConcurrentConveyor<Object>> addrToConveyor = new HashMap<Address, ConcurrentConveyor<Object>>();
            ArrayList<AtomicLong> bytesCounters = new ArrayList<AtomicLong>();
            ArrayList<AtomicLong> itemsCounters = new ArrayList<AtomicLong>();
            SenderTasklet firstTasklet = null;
            for (Address destAddr : this.remoteMembers.get()) {
                ConcurrentConveyor<Object> conveyor = ExecutionPlan.createConveyorArray(1, edge.sourceVertex().localParallelism(), edge.getConfig().getQueueSize())[0];
                ConcurrentInboundEdgeStream inboundEdgeStream = this.newEdgeStream(edge, conveyor, "sender-toVertex:" + edge.destVertex().name() + "-toMember:" + destAddr.toString().replace('.', '-'));
                int destVertexId = edge.destVertex().vertexId();
                SenderTasklet t = new SenderTasklet(inboundEdgeStream, this.nodeEngine, destAddr, this.executionId, destVertexId, edge.getConfig().getPacketSizeLimit());
                if (firstTasklet == null) {
                    firstTasklet = t;
                }
                bytesCounters.add(t.getBytesOutCounter());
                itemsCounters.add(t.getItemsOutCounter());
                this.senderMap.computeIfAbsent(destVertexId, xx -> new HashMap()).computeIfAbsent(edge.destOrdinal(), xx -> new HashMap()).put(destAddr, t);
                this.tasklets.add(t);
                addrToConveyor.put(destAddr, conveyor);
            }
            if (probeBuilder != null && firstTasklet != null) {
                probeBuilder.register(firstTasklet, "distributedBytesOut", ProbeLevel.INFO, ProbeUnit.BYTES, ExecutionPlan.addCountersProbeFunction(bytesCounters));
                probeBuilder.register(firstTasklet, "distributedItemsOut", ProbeLevel.INFO, ProbeUnit.BYTES, ExecutionPlan.addCountersProbeFunction(itemsCounters));
            }
            return addrToConveyor;
        });
    }

    private static <T> LongProbeFunction<T> addCountersProbeFunction(List<AtomicLong> counters) {
        AtomicLong[] countersArray = counters.toArray(new AtomicLong[0]);
        return source -> {
            long total = 0L;
            for (AtomicLong counter : countersArray) {
                total += counter.get();
            }
            return total;
        };
    }

    private static ConcurrentConveyor<Object>[] createConveyorArray(int count, int queueCount, int queueSize) {
        ConcurrentConveyor[] concurrentConveyors = new ConcurrentConveyor[count];
        Arrays.setAll(concurrentConveyors, i -> {
            QueuedPipe[] queues = new QueuedPipe[queueCount];
            Arrays.setAll(queues, j -> new OneToOneConcurrentArrayQueue(queueSize));
            return ConcurrentConveyor.concurrentConveyor(null, queues);
        });
        return concurrentConveyors;
    }

    private OutboundEdgeStream createOutboundEdgeStream(EdgeDef edge, int processorIndex, Map<Address, ConcurrentConveyor<Object>> senderConveyorMap, ProbeBuilder probeBuilder) {
        int totalPtionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        OutboundCollector[] outboundCollectors = this.createOutboundCollectors(edge, processorIndex, senderConveyorMap, probeBuilder);
        OutboundCollector compositeCollector = OutboundCollector.compositeCollector(outboundCollectors, edge, totalPtionCount);
        return new OutboundEdgeStream(edge.sourceOrdinal(), compositeCollector);
    }

    private OutboundCollector[] createOutboundCollectors(EdgeDef edge, int processorIndex, Map<Address, ConcurrentConveyor<Object>> senderConveyorMap, ProbeBuilder probeBuilder) {
        int upstreamParallelism = edge.sourceVertex().localParallelism();
        int downstreamParallelism = edge.destVertex().localParallelism();
        int numRemoteMembers = this.ptionArrgmt.remotePartitionAssignment.get().size();
        int queueSize = edge.getConfig().getQueueSize();
        if (edge.routingPolicy() == Edge.RoutingPolicy.ISOLATED) {
            if (downstreamParallelism < upstreamParallelism) {
                throw new IllegalArgumentException(String.format("The edge %s specifies the %s routing policy, but the downstream vertex parallelism (%d) is less than the upstream vertex parallelism (%d)", edge, Edge.RoutingPolicy.ISOLATED.name(), downstreamParallelism, upstreamParallelism));
            }
            if (edge.isDistributed()) {
                throw new IllegalArgumentException("Isolated edges must be local: " + edge);
            }
            ConcurrentConveyor[] localConveyors = this.localConveyorMap.computeIfAbsent(edge.edgeId(), e -> ExecutionPlan.createConveyorArray(downstreamParallelism, 1, queueSize));
            return (OutboundCollector[])IntStream.range(0, downstreamParallelism).filter(i -> i % upstreamParallelism == processorIndex).mapToObj(i -> new ConveyorCollector(localConveyors[i], 0, null)).toArray(OutboundCollector[]::new);
        }
        int[][] ptionsPerProcessor = this.getPartitionDistribution(edge, downstreamParallelism);
        ConcurrentConveyor[] localConveyors = this.localConveyorMap.computeIfAbsent(edge.edgeId(), e -> {
            int queueCount = upstreamParallelism + (edge.isDistributed() ? numRemoteMembers : 0);
            return ExecutionPlan.createConveyorArray(downstreamParallelism, queueCount, queueSize);
        });
        OutboundCollector[] localCollectors = new OutboundCollector[downstreamParallelism];
        Arrays.setAll(localCollectors, n -> new ConveyorCollector(localConveyors[n], processorIndex, ptionsPerProcessor[n]));
        if (!edge.isDistributed()) {
            return localCollectors;
        }
        int totalPtionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        this.createIfAbsentReceiverTasklet(edge, ptionsPerProcessor, totalPtionCount, probeBuilder);
        Map<Address, int[]> memberToPartitions = this.ptionArrgmt.remotePartitionAssignment.get();
        OutboundCollector[] allCollectors = new OutboundCollector[memberToPartitions.size() + 1];
        allCollectors[0] = OutboundCollector.compositeCollector(localCollectors, edge, totalPtionCount);
        int index = 1;
        for (Map.Entry<Address, int[]> entry : memberToPartitions.entrySet()) {
            allCollectors[index++] = new ConveyorCollectorWithPartition(senderConveyorMap.get(entry.getKey()), processorIndex, entry.getValue());
        }
        return allCollectors;
    }

    private int[][] getPartitionDistribution(EdgeDef edge, int downstreamParallelism) {
        return edge.routingPolicy().equals(Edge.RoutingPolicy.PARTITIONED) ? (Object)this.ptionArrgmt.assignPartitionsToProcessors(downstreamParallelism, edge.isDistributed()) : new int[downstreamParallelism][];
    }

    private void createIfAbsentReceiverTasklet(EdgeDef edge, int[][] ptionsPerProcessor, int totalPtionCount, ProbeBuilder probeBuilder) {
        ConcurrentConveyor[] localConveyors = this.localConveyorMap.get(edge.edgeId());
        this.receiverMap.computeIfAbsent(edge.destVertex().vertexId(), x -> new HashMap()).computeIfAbsent(edge.destOrdinal(), x -> {
            HashMap<Address, ReceiverTasklet> addrToTasklet = new HashMap<Address, ReceiverTasklet>();
            int offset = 0;
            ArrayList<AtomicLong> itemCounters = new ArrayList<AtomicLong>();
            ArrayList<AtomicLong> bytesCounters = new ArrayList<AtomicLong>();
            ReceiverTasklet firstTasklet = null;
            for (Address addr : this.ptionArrgmt.remotePartitionAssignment.get().keySet()) {
                OutboundCollector[] collectors = new OutboundCollector[ptionsPerProcessor.length];
                int queueOffset = --offset;
                Arrays.setAll(collectors, n -> new ConveyorCollector(localConveyors[n], localConveyors[n].queueCount() + queueOffset, ptionsPerProcessor[n]));
                OutboundCollector collector = OutboundCollector.compositeCollector(collectors, edge, totalPtionCount);
                ReceiverTasklet receiverTasklet = new ReceiverTasklet(collector, edge.getConfig().getReceiveWindowMultiplier(), this.getConfig().getInstanceConfig().getFlowControlPeriodMs(), this.nodeEngine.getLoggingService(), "receiverFor:" + edge.destVertex().name() + "#" + edge.destOrdinal());
                addrToTasklet.put(addr, receiverTasklet);
                if (firstTasklet == null) {
                    firstTasklet = receiverTasklet;
                }
                itemCounters.add(receiverTasklet.getItemsInCounter());
                bytesCounters.add(receiverTasklet.getBytesInCounter());
            }
            if (probeBuilder != null && firstTasklet != null) {
                probeBuilder.register(firstTasklet, "distributedItemsIn", ProbeLevel.INFO, ProbeUnit.COUNT, ExecutionPlan.addCountersProbeFunction(itemCounters));
                probeBuilder.register(firstTasklet, "distributedBytesIn", ProbeLevel.INFO, ProbeUnit.COUNT, ExecutionPlan.addCountersProbeFunction(bytesCounters));
            }
            return addrToTasklet;
        });
    }

    private JetConfig getConfig() {
        JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
        return service.getJetInstance().getConfig();
    }

    private List<InboundEdgeStream> createInboundEdgeStreams(VertexDef srcVertex, int localProcessorIdx, int globalProcessorIdx) {
        ArrayList<InboundEdgeStream> inboundStreams = new ArrayList<InboundEdgeStream>();
        for (EdgeDef inEdge : srcVertex.inboundEdges()) {
            ConcurrentConveyor<Object> conveyor = this.localConveyorMap.get(inEdge.edgeId())[localProcessorIdx];
            inboundStreams.add(this.newEdgeStream(inEdge, conveyor, "inputTo:" + inEdge.destVertex().name() + '#' + globalProcessorIdx));
        }
        return inboundStreams;
    }

    private ConcurrentInboundEdgeStream newEdgeStream(EdgeDef inEdge, ConcurrentConveyor<Object> conveyor, String debugName) {
        return new ConcurrentInboundEdgeStream(conveyor, inEdge.destOrdinal(), inEdge.priority(), this.jobConfig.getProcessingGuarantee() == ProcessingGuarantee.EXACTLY_ONCE, debugName);
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public long lastSnapshotId() {
        return this.lastSnapshotId;
    }

    public int getStoreSnapshotTaskletCount() {
        return (int)this.tasklets.stream().filter(t -> t instanceof StoreSnapshotTasklet).count();
    }

    public int getHigherPriorityVertexCount() {
        return VertexDef.getHigherPriorityVertices(this.vertices).size();
    }

    List<VertexDef> getVertices() {
        return this.vertices;
    }
}

