 package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Bits;

/**
 * @since 1.0
 * update 1.0
 */
@edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetGetJobIdsCodec {

    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_GETJOBIDS;
    public static final int RESPONSE_TYPE = 132;

    //************************ REQUEST *************************//

    public static class RequestParameters {
    public static final JetMessageType TYPE = REQUEST_TYPE;

         /**
         * @since 1.0
         */

         /**
         * @since 1.0
         */
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

         /**
         * @since 1.0
         */
        public static ClientMessage encodeRequest() {
            final int requiredDataSize = RequestParameters.calculateDataSize();
            ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
            clientMessage.setMessageType(REQUEST_TYPE.id());
            clientMessage.setRetryable(true);
            clientMessage.setAcquiresResource(false);
            clientMessage.setOperationName("Jet.getJobIds");
            clientMessage.updateFrameLength();
            return clientMessage;
        }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        final RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    //************************ RESPONSE *************************//

    public static class ResponseParameters {
         /**
         * @since 1.0
         */
        public java.util.List<java.lang.Long> response;

         /**
         * @since 1.0
         */
        public static int calculateDataSize( java.util.Collection<java.lang.Long> response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += Bits.INT_SIZE_IN_BYTES;
            for (java.lang.Long response_item : response ) {
            dataSize += ParameterUtil.calculateDataSize(response_item);
            }
            return dataSize;
        }
    }

    /**
    * @since 1.0
    */
    public static ClientMessage encodeResponse(java.util.Collection<java.lang.Long> response) {
        final int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(RESPONSE_TYPE);
        clientMessage.set(response.size());
        for (java.lang.Long response_item : response) {
        clientMessage.set(response_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;

    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        java.util.List<java.lang.Long> response = null
;
            int response_size = clientMessage.getInt();
            response = new java.util.ArrayList<java.lang.Long>(response_size);
            for (int response_index = 0;response_index<response_size;response_index++) {
                java.lang.Long response_item;
        response_item = clientMessage.getLong();
                response.add(response_item);
            }
            parameters.response = response;
    
        return parameters;
    }

}
