 package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Bits;

/**
 * @since 1.0
 * update 1.0
 */
@edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetExportSnapshotCodec {

    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_EXPORTSNAPSHOT;
    public static final int RESPONSE_TYPE = 100;

    //************************ REQUEST *************************//

    public static class RequestParameters {
    public static final JetMessageType TYPE = REQUEST_TYPE;

         /**
         * @since 1.0
         */
        public long jobId;
        public java.lang.String name;
        public boolean cancelJob;

         /**
         * @since 1.0
         */
        public static int calculateDataSize(long jobId, java.lang.String name, boolean cancelJob) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += Bits.LONG_SIZE_IN_BYTES;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += Bits.BOOLEAN_SIZE_IN_BYTES;
            return dataSize;
        }
    }

         /**
         * @since 1.0
         */
        public static ClientMessage encodeRequest(long jobId, java.lang.String name, boolean cancelJob) {
            final int requiredDataSize = RequestParameters.calculateDataSize(jobId, name, cancelJob);
            ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
            clientMessage.setMessageType(REQUEST_TYPE.id());
            clientMessage.setRetryable(false);
            clientMessage.setAcquiresResource(false);
            clientMessage.setOperationName("Jet.exportSnapshot");
        clientMessage.set(jobId);
        clientMessage.set(name);
        clientMessage.set(cancelJob);
            clientMessage.updateFrameLength();
            return clientMessage;
        }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        final RequestParameters parameters = new RequestParameters();
        long jobId = 0
;
        jobId = clientMessage.getLong();
            parameters.jobId = jobId;
    
        java.lang.String name = null
;
        name = clientMessage.getStringUtf8();
            parameters.name = name;
    
        boolean cancelJob = false
;
        cancelJob = clientMessage.getBoolean();
            parameters.cancelJob = cancelJob;
    
        return parameters;
    }

    //************************ RESPONSE *************************//

    public static class ResponseParameters {
         /**
         * @since 1.0
         */

         /**
         * @since 1.0
         */
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

    /**
    * @since 1.0
    */
    public static ClientMessage encodeResponse() {
        final int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(RESPONSE_TYPE);
        clientMessage.updateFrameLength();
        return clientMessage;

    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

}
