/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.impl.connector.WriteJmsP;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

public final class JmsSinkBuilder<T> {
    private final SupplierEx<ConnectionFactory> factorySupplier;
    private final boolean isTopic;
    private FunctionEx<ConnectionFactory, Connection> connectionFn;
    private FunctionEx<Connection, Session> sessionFn;
    private BiFunctionEx<Session, T, Message> messageFn;
    private BiConsumerEx<MessageProducer, Message> sendFn;
    private ConsumerEx<Session> flushFn;
    private String username;
    private String password;
    private boolean transacted;
    private int acknowledgeMode = 1;
    private String destinationName;

    JmsSinkBuilder(@Nonnull SupplierEx<ConnectionFactory> factorySupplier, boolean isTopic) {
        Util.checkSerializable(factorySupplier, "factorySupplier");
        this.factorySupplier = factorySupplier;
        this.isTopic = isTopic;
    }

    public JmsSinkBuilder<T> connectionParams(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public JmsSinkBuilder<T> connectionFn(@Nonnull FunctionEx<ConnectionFactory, Connection> connectionFn) {
        Util.checkSerializable(connectionFn, "connectionFn");
        this.connectionFn = connectionFn;
        return this;
    }

    public JmsSinkBuilder<T> sessionParams(boolean transacted, int acknowledgeMode) {
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        return this;
    }

    public JmsSinkBuilder<T> sessionFn(@Nonnull FunctionEx<Connection, Session> sessionFn) {
        Util.checkSerializable(sessionFn, "sessionFn");
        this.sessionFn = sessionFn;
        return this;
    }

    public JmsSinkBuilder<T> destinationName(@Nonnull String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    public JmsSinkBuilder<T> messageFn(BiFunctionEx<Session, T, Message> messageFn) {
        Util.checkSerializable(messageFn, "messageFn");
        this.messageFn = messageFn;
        return this;
    }

    public JmsSinkBuilder<T> sendFn(BiConsumerEx<MessageProducer, Message> sendFn) {
        Util.checkSerializable(sendFn, "sendFn");
        this.sendFn = sendFn;
        return this;
    }

    public JmsSinkBuilder<T> flushFn(ConsumerEx<Session> flushFn) {
        Util.checkSerializable(flushFn, "flushFn");
        this.flushFn = flushFn;
        return this;
    }

    public Sink<T> build() {
        String usernameLocal = this.username;
        String passwordLocal = this.password;
        boolean transactedLocal = this.transacted;
        int acknowledgeModeLocal = this.acknowledgeMode;
        Preconditions.checkNotNull(this.destinationName);
        if (this.connectionFn == null) {
            this.connectionFn = factory -> factory.createConnection(usernameLocal, passwordLocal);
        }
        if (this.sessionFn == null) {
            this.sessionFn = connection -> connection.createSession(transactedLocal, acknowledgeModeLocal);
        }
        if (this.messageFn == null) {
            this.messageFn = (session, item) -> item instanceof Message ? (Message)item : session.createTextMessage(item.toString());
        }
        if (this.sendFn == null) {
            this.sendFn = MessageProducer::send;
        }
        if (this.flushFn == null) {
            this.flushFn = ConsumerEx.noop();
        }
        FunctionEx<ConnectionFactory, Connection> connectionFnLocal = this.connectionFn;
        SupplierEx<ConnectionFactory> factorySupplierLocal = this.factorySupplier;
        SupplierEx<Connection> connectionSupplier = () -> (Connection)connectionFnLocal.apply((ConnectionFactory)factorySupplierLocal.get());
        return new SinkImpl(this.sinkName(), WriteJmsP.supplier(connectionSupplier, this.sessionFn, this.messageFn, this.sendFn, this.flushFn, this.destinationName, this.isTopic));
    }

    private String sinkName() {
        return String.format("jms%sSink(%s)", this.isTopic ? "Topic" : "Queue", this.destinationName);
    }
}

