/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.server;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.logging.ILogger;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.List;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JetBootstrap {
    private static ClientConfig config;
    private static String jarName;
    private static String snapshotName;
    private static String jobName;
    private static final ConcurrentMemoizingSupplier<JetBootstrap> SUPPLIER;
    private final JetInstance instance;

    private JetBootstrap(JetInstance instance) {
        this.instance = new InstanceProxy((AbstractJetInstance)instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void executeJar(@Nonnull ClientConfig clientConfig, @Nonnull String jar, @Nullable String snapshotName, @Nullable String jobName, @Nonnull List<String> args) throws Exception {
        config = clientConfig;
        jarName = jar;
        JetBootstrap.snapshotName = snapshotName;
        JetBootstrap.jobName = jobName;
        try {
            try (JarFile jarFile = new JarFile(jar);){
                URL jarUrl;
                URLClassLoader classLoader;
                Class<?> clazz;
                Method main;
                int mods;
                String mainClass;
                if (jarFile.getManifest() == null) {
                    JetBootstrap.error("No manifest file in " + jar);
                }
                if ((mainClass = jarFile.getManifest().getMainAttributes().getValue("Main-Class")) == null) {
                    JetBootstrap.error("No Main-Class found in manifest");
                }
                if (((mods = (main = (clazz = (classLoader = AccessController.doPrivileged(() -> JetBootstrap.lambda$executeJar$1(jarUrl = new URL("file:///" + jar)))).loadClass(mainClass)).getDeclaredMethod("main", String[].class)).getModifiers()) & 1) == 0 || (mods & 8) == 0) {
                    JetBootstrap.error("Class " + clazz.getName() + " has a main(String[] args) method which is not public static");
                }
                String[] jobArgs = args.toArray(new String[0]);
                main.invoke(null, new Object[]{jobArgs});
            }
            JetBootstrap remembered = SUPPLIER.remembered();
            if (remembered != null) {
                remembered.instance.shutdown();
            }
        }
        catch (Throwable throwable) {
            JetBootstrap remembered = SUPPLIER.remembered();
            if (remembered != null) {
                remembered.instance.shutdown();
            }
            throw throwable;
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static JetInstance getInstance() {
        if (config == null) {
            throw new JetException("JetBootstrap.getInstance() should be used in conjunction with the jet.sh submit command");
        }
        return JetBootstrap.SUPPLIER.get().instance;
    }

    private static /* synthetic */ URLClassLoader lambda$executeJar$1(URL jarUrl) {
        return new URLClassLoader(new URL[]{jarUrl}, JetBootstrap.class.getClassLoader());
    }

    static {
        SUPPLIER = new ConcurrentMemoizingSupplier<JetBootstrap>(() -> new JetBootstrap(Jet.newJetClient(config)));
    }

    private static class InstanceProxy
    extends AbstractJetInstance {
        private final AbstractJetInstance instance;

        InstanceProxy(AbstractJetInstance instance) {
            super(instance.getHazelcastInstance());
            this.instance = instance;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.instance.getName();
        }

        @Override
        @Nonnull
        public HazelcastInstance getHazelcastInstance() {
            return this.instance.getHazelcastInstance();
        }

        @Override
        @Nonnull
        public Cluster getCluster() {
            return this.instance.getCluster();
        }

        @Override
        @Nonnull
        public JetConfig getConfig() {
            return this.instance.getConfig();
        }

        @Override
        @Nonnull
        public Job newJob(@Nonnull DAG dag) {
            return this.newJob(dag, new JobConfig());
        }

        @Override
        @Nonnull
        public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
            return this.instance.newJob(dag, this.updateJobConfig(config));
        }

        @Override
        @Nonnull
        public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
            return this.instance.newJobIfAbsent(dag, this.updateJobConfig(config));
        }

        private JobConfig updateJobConfig(@Nonnull JobConfig config) {
            if (jarName != null) {
                config.addJar(jarName);
            }
            if (snapshotName != null) {
                config.setInitialSnapshotName(snapshotName);
            }
            if (jobName != null) {
                config.setName(jobName);
            }
            return config;
        }

        @Override
        @Nonnull
        public List<Job> getJobs() {
            return this.instance.getJobs();
        }

        @Override
        public Job getJob(long jobId) {
            return this.instance.getJob(jobId);
        }

        @Override
        @Nonnull
        public List<Job> getJobs(@Nonnull String name) {
            return this.instance.getJobs(name);
        }

        @Override
        @Nonnull
        public <K, V> IMapJet<K, V> getMap(@Nonnull String name) {
            return this.instance.getMap(name);
        }

        @Override
        @Nonnull
        public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
            return this.instance.getReplicatedMap(name);
        }

        @Override
        @Nonnull
        public JetCacheManager getCacheManager() {
            return this.instance.getCacheManager();
        }

        @Override
        @Nonnull
        public <E> IListJet<E> getList(@Nonnull String name) {
            return this.instance.getList(name);
        }

        @Override
        public void shutdown() {
            this.instance.shutdown();
        }

        @Override
        public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
            return this.instance.existsDistributedObject(serviceName, objectName);
        }

        @Override
        public ILogger getLogger() {
            return this.instance.getLogger();
        }

        @Override
        public Job newJobProxy(long jobId) {
            return this.instance.newJobProxy(jobId);
        }

        @Override
        public Job newJobProxy(long jobId, DAG dag, JobConfig config) {
            return this.instance.newJobProxy(jobId, dag, config);
        }

        @Override
        public List<Long> getJobIdsByName(String name) {
            return this.instance.getJobIdsByName(name);
        }
    }
}

