/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.core.IMap;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BiPredicateEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.function.ToLongFunctionEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.ContextFactories;
import com.hazelcast.jet.pipeline.ContextFactory;
import com.hazelcast.jet.pipeline.GeneralHashJoinBuilder;
import com.hazelcast.jet.pipeline.GeneralStageWithKey;
import com.hazelcast.jet.pipeline.JoinClause;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.Stage;
import com.hazelcast.jet.pipeline.StreamStage;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface GeneralStage<T>
extends Stage {
    @Nonnull
    public <R> GeneralStage<R> map(@Nonnull FunctionEx<? super T, ? extends R> var1);

    @Nonnull
    public GeneralStage<T> filter(@Nonnull PredicateEx<T> var1);

    @Nonnull
    public <R> GeneralStage<R> flatMap(@Nonnull FunctionEx<? super T, ? extends Traverser<? extends R>> var1);

    @Nonnull
    public <C, R> GeneralStage<R> mapUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull BiFunctionEx<? super C, ? super T, ? extends R> var2);

    @Nonnull
    public <C, R> GeneralStage<R> mapUsingContextAsync(@Nonnull ContextFactory<C> var1, @Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<R>> var2);

    @Nonnull
    public <C> GeneralStage<T> filterUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull BiPredicateEx<? super C, ? super T> var2);

    @Nonnull
    public <C> GeneralStage<T> filterUsingContextAsync(@Nonnull ContextFactory<C> var1, @Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<Boolean>> var2);

    @Nonnull
    public <C, R> GeneralStage<R> flatMapUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull BiFunctionEx<? super C, ? super T, ? extends Traverser<R>> var2);

    @Nonnull
    public <C, R> GeneralStage<R> flatMapUsingContextAsync(@Nonnull ContextFactory<C> var1, @Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<Traverser<R>>> var2);

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingReplicatedMap(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingContext(ContextFactories.replicatedMapContext(mapName), (map, t) -> mapFn.apply((Object)t, (Object)map.get(lookupKeyFn.apply(t))));
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingReplicatedMap(@Nonnull ReplicatedMap<K, V> replicatedMap, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingReplicatedMap(replicatedMap.getName(), lookupKeyFn, mapFn);
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingIMap(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingContextAsync(ContextFactories.iMapContext(mapName), (map, t) -> Util.toCompletableFuture(map.getAsync(lookupKeyFn.apply(t))).thenApply(e -> mapFn.apply((Object)t, (Object)e)));
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingIMap(@Nonnull IMap<K, V> iMap, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingIMap(iMap.getName(), lookupKeyFn, mapFn);
    }

    @Nonnull
    public <R> GeneralStage<R> rollingAggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> var1);

    @Nonnull
    public <K, T1_IN, T1, R> GeneralStage<R> hashJoin(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull BiFunctionEx<T, T1, R> var3);

    @Nonnull
    public <K1, K2, T1_IN, T2_IN, T1, T2, R> GeneralStage<R> hashJoin2(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K1, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull BatchStage<T2_IN> var3, @Nonnull JoinClause<K2, ? super T, ? super T2_IN, ? extends T2> var4, @Nonnull TriFunction<T, T1, T2, R> var5);

    @Nonnull
    public GeneralHashJoinBuilder<T> hashJoinBuilder();

    @Nonnull
    public <K> GeneralStageWithKey<T, K> groupingKey(@Nonnull FunctionEx<? super T, ? extends K> var1);

    @Nonnull
    public StreamStage<T> addTimestamps(@Nonnull ToLongFunctionEx<? super T> var1, long var2);

    @Nonnull
    public SinkStage drainTo(@Nonnull Sink<? super T> var1);

    @Nonnull
    public GeneralStage<T> peek(@Nonnull PredicateEx<? super T> var1, @Nonnull FunctionEx<? super T, ? extends CharSequence> var2);

    @Nonnull
    default public GeneralStage<T> peek(@Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn) {
        return this.peek(PredicateEx.alwaysTrue(), toStringFn);
    }

    @Nonnull
    default public GeneralStage<T> peek() {
        return this.peek(PredicateEx.alwaysTrue(), Object::toString);
    }

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull SupplierEx<Processor> var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorSupplier var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorMetaSupplier var2);
}

