/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public class TimestampTransform<T>
extends AbstractTransform {
    @Nonnull
    private EventTimePolicy<? super T> eventTimePolicy;

    public TimestampTransform(@Nonnull Transform upstream, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        super("add-timestamps", upstream);
        this.eventTimePolicy = eventTimePolicy;
        Preconditions.checkNotNull(eventTimePolicy.timestampFn(), "timestampFn must not be null if timestamps aren't added in the source");
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.localParallelism(), Processors.insertWatermarksP(this.eventTimePolicy));
        p.addEdges(this, pv.v);
    }

    @Nonnull
    public EventTimePolicy<? super T> getEventTimePolicy() {
        return this.eventTimePolicy;
    }

    public void setEventTimePolicy(@Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        this.eventTimePolicy = eventTimePolicy;
    }
}

