/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.impl.ClusterMetadata;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.exception.TargetNotMemberException;

public class GetClusterMetadataOperation
extends Operation
implements IdentifiedDataSerializable,
ReadonlyOperation {
    private ClusterMetadata response;

    @Override
    public void run() {
        JetService service = (JetService)this.getService();
        HazelcastInstance instance = service.getJetInstance().getHazelcastInstance();
        Cluster cluster = instance.getCluster();
        String name = instance.getConfig().getGroupConfig().getName();
        this.response = new ClusterMetadata(name, cluster);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 37;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return throwable instanceof TargetNotMemberException ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }
}

