/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics.management;

import com.hazelcast.jet.impl.metrics.JetMetricsService;
import com.hazelcast.jet.impl.metrics.management.ConcurrentArrayRingbuffer;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ReadonlyOperation;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ReadMetricsOperation
extends Operation
implements ReadonlyOperation {
    private long offset;

    public ReadMetricsOperation(long offset) {
        this.offset = offset;
    }

    @Override
    public void beforeRun() {
        JetMetricsService service = (JetMetricsService)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    @Override
    public void run() {
        ILogger logger = this.getNodeEngine().getLogger(this.getClass());
        JetMetricsService service = (JetMetricsService)this.getService();
        CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future = service.readMetrics(this.offset);
        future.whenComplete(ExceptionUtil.withTryCatch(logger, (slice, error) -> this.doSendResponse(error != null ? ExceptionUtil.peel(error) : slice)));
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:jetMetricsService";
    }

    private void doSendResponse(Object value) {
        try {
            this.sendResponse(value);
        }
        finally {
            JetMetricsService service = (JetMetricsService)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
    }
}

