/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobProxy;
import com.hazelcast.jet.impl.operation.GetJobIdsByNameOperation;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JetInstanceImpl
extends AbstractJetInstance {
    private final NodeEngine nodeEngine;
    private final JetConfig config;

    JetInstanceImpl(HazelcastInstanceImpl hazelcastInstance, JetConfig config) {
        super(hazelcastInstance);
        this.nodeEngine = hazelcastInstance.node.getNodeEngine();
        this.config = config;
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public List<Job> getJobs() {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        InternalCompletableFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new GetJobIdsOperation(), masterAddress).invoke();
        try {
            return ((List)future.get()).stream().map(jobId -> new JobProxy((NodeEngineImpl)this.nodeEngine, (long)jobId)).collect(Collectors.toList());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public List<Long> getJobIdsByName(String name) {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        InternalCompletableFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new GetJobIdsByNameOperation(name), masterAddress).invoke();
        try {
            return (List)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void shutdown() {
        try {
            JetService jetService = (JetService)this.nodeEngine.getService("hz:impl:jetService");
            jetService.shutDownJobs();
            super.shutdown();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return Util.existsDistributedObject(this.nodeEngine, serviceName, objectName);
    }

    @Override
    public Job newJobProxy(long jobId) {
        return new JobProxy((NodeEngineImpl)this.nodeEngine, jobId);
    }

    @Override
    public Job newJobProxy(long jobId, DAG dag, JobConfig config) {
        return new JobProxy((NodeEngineImpl)this.nodeEngine, jobId, dag, config);
    }

    @Override
    public ILogger getLogger() {
        return this.nodeEngine.getLogger(this.getClass());
    }
}

