/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.jet.config.JobClassLoaderFactory;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobConfig
implements IdentifiedDataSerializable {
    private static final long SNAPSHOT_INTERVAL_MILLIS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private String name;
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;
    private long snapshotIntervalMillis = SNAPSHOT_INTERVAL_MILLIS_DEFAULT;
    private boolean autoScaling = true;
    private boolean splitBrainProtectionEnabled;
    private List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();
    private JobClassLoaderFactory classLoaderFactory;
    private String initialSnapshotName;

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public JobConfig setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public boolean isSplitBrainProtectionEnabled() {
        return this.splitBrainProtectionEnabled;
    }

    @Nonnull
    public JobConfig setSplitBrainProtection(boolean isEnabled) {
        this.splitBrainProtectionEnabled = isEnabled;
        return this;
    }

    public JobConfig setAutoScaling(boolean enabled) {
        this.autoScaling = enabled;
        return this;
    }

    public boolean isAutoScaling() {
        return this.autoScaling;
    }

    @Nonnull
    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    @Nonnull
    public JobConfig setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMillis;
    }

    @Nonnull
    public JobConfig setSnapshotIntervalMillis(long snapshotInterval) {
        Preconditions.checkNotNegative(snapshotInterval, "snapshotInterval can't be negative");
        this.snapshotIntervalMillis = snapshotInterval;
        return this;
    }

    @Nonnull
    public JobConfig addClass(Class ... classes) {
        Preconditions.checkNotNull(classes, "Classes can not be null");
        for (Class clazz : classes) {
            this.resourceConfigs.add(new ResourceConfig(clazz));
        }
        return this;
    }

    @Nonnull
    public JobConfig addJar(@Nonnull URL url) {
        return this.add(url, null, true);
    }

    @Nonnull
    public JobConfig addJar(@Nonnull File file) {
        try {
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addJar(@Nonnull String path) {
        try {
            File file = new File(path);
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull URL url) {
        return this.addResource(url, JobConfig.toFilename(url));
    }

    @Nonnull
    public JobConfig addResource(@Nonnull URL url, @Nonnull String id) {
        return this.add(url, id, false);
    }

    @Nonnull
    public JobConfig addResource(@Nonnull File file) {
        try {
            return this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull File file, @Nonnull String id) {
        try {
            return this.add(file.toURI().toURL(), id, false);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull String path) {
        return this.addResource(new File(path));
    }

    @Nonnull
    public JobConfig addResource(@Nonnull String path, @Nonnull String id) {
        return this.addResource(new File(path), id);
    }

    @Nonnull
    public List<ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    private JobConfig add(URL url, String id, boolean isJar) {
        this.resourceConfigs.add(new ResourceConfig(url, id, isJar));
        return this;
    }

    private static String toFilename(URL url) {
        String urlFile = url.getPath();
        return urlFile.substring(urlFile.lastIndexOf(47) + 1);
    }

    @Nonnull
    public JobConfig setClassLoaderFactory(@Nullable JobClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
        return this;
    }

    @Nullable
    public JobClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    @Nullable
    public String getInitialSnapshotName() {
        return this.initialSnapshotName;
    }

    @Nonnull
    public JobConfig setInitialSnapshotName(@Nullable String initialSnapshotName) {
        this.initialSnapshotName = initialSnapshotName;
        return this;
    }

    @Override
    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject((Object)this.processingGuarantee);
        out.writeLong(this.snapshotIntervalMillis);
        out.writeBoolean(this.autoScaling);
        out.writeBoolean(this.splitBrainProtectionEnabled);
        out.writeObject(this.resourceConfigs);
        out.writeObject(this.classLoaderFactory);
        out.writeUTF(this.initialSnapshotName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.processingGuarantee = (ProcessingGuarantee)((Object)in.readObject());
        this.snapshotIntervalMillis = in.readLong();
        this.autoScaling = in.readBoolean();
        this.splitBrainProtectionEnabled = in.readBoolean();
        this.resourceConfigs = (List)in.readObject();
        this.classLoaderFactory = (JobClassLoaderFactory)in.readObject();
        this.initialSnapshotName = in.readUTF();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobConfig jobConfig = (JobConfig)o;
        if (this.snapshotIntervalMillis != jobConfig.snapshotIntervalMillis) {
            return false;
        }
        if (this.autoScaling != jobConfig.autoScaling) {
            return false;
        }
        if (this.splitBrainProtectionEnabled != jobConfig.splitBrainProtectionEnabled) {
            return false;
        }
        if (!Objects.equals(this.name, jobConfig.name)) {
            return false;
        }
        if (this.processingGuarantee != jobConfig.processingGuarantee) {
            return false;
        }
        if (!Objects.equals(this.resourceConfigs, jobConfig.resourceConfigs)) {
            return false;
        }
        if (!Objects.equals(this.classLoaderFactory, jobConfig.classLoaderFactory)) {
            return false;
        }
        return Objects.equals(this.initialSnapshotName, jobConfig.initialSnapshotName);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.processingGuarantee != null ? this.processingGuarantee.hashCode() : 0);
        result = 31 * result + (int)(this.snapshotIntervalMillis ^ this.snapshotIntervalMillis >>> 32);
        result = 31 * result + (this.autoScaling ? 1 : 0);
        result = 31 * result + (this.splitBrainProtectionEnabled ? 1 : 0);
        result = 31 * result + (this.resourceConfigs != null ? this.resourceConfigs.hashCode() : 0);
        result = 31 * result + (this.classLoaderFactory != null ? this.classLoaderFactory.hashCode() : 0);
        result = 31 * result + (this.initialSnapshotName != null ? this.initialSnapshotName.hashCode() : 0);
        return result;
    }
}

