/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JetNodeContext;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;
import com.hazelcast.jet.impl.metrics.JetMetricsService;
import com.hazelcast.jet.impl.util.JetProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.merge.IgnoreMergingEntryMapMergePolicy;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.Preconditions;
import java.util.Properties;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class Jet {
    private static final ILogger LOGGER = Logger.getLogger(Jet.class);

    private Jet() {
    }

    @Nonnull
    public static JetInstance newJetInstance() {
        return Jet.newJetInstance(JetConfig.loadDefault());
    }

    @Nonnull
    public static JetInstance newJetInstance(@Nonnull JetConfig config) {
        Preconditions.checkNotNull(config, "config");
        return Jet.newJetInstanceImpl(config, cfg -> HazelcastInstanceFactory.newHazelcastInstance(cfg, cfg.getInstanceName(), new JetNodeContext()));
    }

    @Nonnull
    public static JetInstance newJetClient() {
        ClientConfig clientConfig = XmlJetConfigBuilder.getClientConfig();
        return Jet.newJetClient(clientConfig);
    }

    @Nonnull
    public static JetInstance newJetClient(@Nonnull ClientConfig config) {
        Preconditions.checkNotNull(config, "config");
        return Jet.getJetClientInstance(HazelcastClient.newHazelcastClient(config));
    }

    public static void shutdownAll() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    static JetInstance newJetInstanceImpl(JetConfig config, Function<Config, HazelcastInstance> newHzFn) {
        Jet.configureJetService(config);
        HazelcastInstanceImpl hzImpl = ((HazelcastInstanceProxy)newHzFn.apply(config.getHazelcastConfig())).getOriginal();
        JetService jetService = (JetService)hzImpl.node.nodeEngine.getService("hz:impl:jetService");
        return jetService.getJetInstance();
    }

    static JetClientInstanceImpl getJetClientInstance(HazelcastInstance client) {
        return new JetClientInstanceImpl(((HazelcastClientProxy)client).client);
    }

    private static synchronized void configureJetService(JetConfig jetConfig) {
        Config hzConfig = jetConfig.getHazelcastConfig();
        if (!(hzConfig.getConfigPatternMatcher() instanceof MatchingPointConfigPatternMatcher)) {
            throw new UnsupportedOperationException("Custom config pattern matcher is not supported in Jet");
        }
        Properties jetProps = jetConfig.getProperties();
        Properties hzProperties = hzConfig.getProperties();
        String hzHookEnabled = hzProperties.getProperty(GroupProperty.SHUTDOWNHOOK_ENABLED.getName(), GroupProperty.SHUTDOWNHOOK_ENABLED.getDefaultValue());
        if (!jetProps.containsKey(JetProperties.JET_SHUTDOWNHOOK_ENABLED)) {
            jetProps.setProperty(JetProperties.JET_SHUTDOWNHOOK_ENABLED.getName(), hzHookEnabled);
        }
        hzConfig.setProperty(GroupProperty.SHUTDOWNHOOK_ENABLED.getName(), "false");
        for (String prop : jetProps.stringPropertyNames()) {
            hzProperties.setProperty(prop, jetProps.getProperty(prop));
        }
        hzConfig.getServicesConfig().addServiceConfig(new ServiceConfig().setEnabled(false).setName("hz:impl:jetService").setClassName(JetService.class.getName()).setConfigObject(jetConfig)).addServiceConfig(new ServiceConfig().setEnabled(true).setName("hz:impl:jetMetricsService").setClassName(JetMetricsService.class.getName()).setConfigObject(jetConfig.getMetricsConfig()));
        MapConfig internalMapConfig = new MapConfig("__jet.*").setBackupCount(jetConfig.getInstanceConfig().getBackupCount()).setStatisticsEnabled(true);
        internalMapConfig.getMergePolicyConfig().setPolicy(IgnoreMergingEntryMapMergePolicy.class.getName());
        HazelcastProperties properties = new HazelcastProperties(hzProperties);
        MapConfig resultsMapConfig = new MapConfig(internalMapConfig).setName("__jet.results").setTimeToLiveSeconds(properties.getSeconds(JetProperties.JOB_RESULTS_TTL_SECONDS));
        hzConfig.addMapConfig(internalMapConfig).addMapConfig(resultsMapConfig);
        if (jetConfig.getInstanceConfig().isLosslessRestartEnabled() && !hzConfig.getHotRestartPersistenceConfig().isEnabled()) {
            LOGGER.warning("Lossless recovery is enabled but Hot Restart is disabled. Auto-enabling Hot Restart. The following path will be used: " + hzConfig.getHotRestartPersistenceConfig().getBaseDir());
            hzConfig.getHotRestartPersistenceConfig().setEnabled(true);
        }
        MetricsConfig metricsConfig = jetConfig.getMetricsConfig();
        JetMetricsService.applyMetricsConfig(hzConfig, metricsConfig);
    }
}

