/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.pipeline.WindowDefinition;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public class SlidingWindowDef
implements WindowDefinition {
    private final long windowSize;
    private final long slideBy;

    SlidingWindowDef(long windowSize, long slideBy) {
        Preconditions.checkPositive(windowSize, "windowSize must be positive");
        Preconditions.checkPositive(slideBy, "slideBy must be positive");
        Preconditions.checkTrue(windowSize % slideBy == 0L, "windowSize must be integer multiple of slideBy, mod(" + windowSize + ", " + slideBy + ") != 0");
        this.windowSize = windowSize;
        this.slideBy = slideBy;
    }

    @Override
    @Nonnull
    public WindowDefinition.WindowKind kind() {
        return WindowDefinition.WindowKind.SLIDING;
    }

    @Nonnull
    public SlidingWindowDef downcast() {
        return this;
    }

    @Override
    public long watermarkFrameSize() {
        return this.slideBy;
    }

    public long windowSize() {
        return this.windowSize;
    }

    public long slideBy() {
        return this.slideBy;
    }

    public SlidingWindowPolicy toSlidingWindowPolicy() {
        return SlidingWindowPolicy.slidingWinPolicy(this.windowSize, this.slideBy);
    }
}

