/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class TerminateJobOperation
extends AbstractJobOperation
implements IdentifiedDataSerializable {
    private TerminationMode terminationMode;

    public TerminateJobOperation() {
    }

    public TerminateJobOperation(long jobId, TerminationMode mode) {
        super(jobId);
        this.terminationMode = mode;
    }

    @Override
    public void run() {
        JetService service = (JetService)this.getService();
        service.getJobCoordinationService().terminateJob(this.jobId(), this.terminationMode);
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeByte(this.terminationMode.ordinal());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.terminationMode = TerminationMode.values()[in.readByte()];
    }
}

