/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics.jmx;

import com.hazelcast.internal.metrics.MetricsUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.impl.metrics.MetricsPublisher;
import com.hazelcast.jet.impl.metrics.jmx.MetricsMBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxPublisher
implements MetricsPublisher {
    private final MBeanServer platformMBeanServer;
    private final String instanceNameEscaped;
    private final Map<String, MetricData> metricNameToMetricData = new HashMap<String, MetricData>();
    private final Map<ObjectName, MetricsMBean> mBeans = new HashMap<ObjectName, MetricsMBean>();
    private final String domainPrefix;
    private volatile boolean isShutdown;

    public JmxPublisher(String instanceName, String domainPrefix) {
        this.domainPrefix = domainPrefix;
        this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.instanceNameEscaped = JmxPublisher.escapeObjectNameValue(instanceName);
    }

    @Override
    public String name() {
        return "JMX Publisher";
    }

    @Override
    public void publishLong(String metricName, long value) {
        this.publishNumber(metricName, value);
    }

    @Override
    public void publishDouble(String metricName, double value) {
        this.publishNumber(metricName, value);
    }

    private void publishNumber(String metricName, Number value) {
        MetricData metricData = this.metricNameToMetricData.computeIfAbsent(metricName, n -> new MetricData((String)n, this.instanceNameEscaped, this.domainPrefix));
        assert (!metricData.wasPresent) : "metric '" + metricName + "' was rendered twice";
        metricData.wasPresent = true;
        MetricsMBean mBean = this.mBeans.computeIfAbsent(metricData.objectName, objectName -> {
            MetricsMBean bean = new MetricsMBean();
            try {
                this.platformMBeanServer.registerMBean(bean, (ObjectName)objectName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return bean;
        });
        if (this.isShutdown) {
            this.unregisterMBeanIgnoreError(metricData.objectName);
        }
        mBean.setMetricValue(metricData.metric, metricData.unit, value);
    }

    private void unregisterMBeanIgnoreError(ObjectName objectName) {
        try {
            this.platformMBeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void whenComplete() {
        Iterator<MetricData> iterator = this.metricNameToMetricData.values().iterator();
        while (iterator.hasNext()) {
            MetricData metricData = iterator.next();
            if (!metricData.wasPresent) {
                iterator.remove();
                MetricsMBean mBean = this.mBeans.get(metricData.objectName);
                mBean.removeMetric(metricData.metric);
                if (mBean.numAttributes() != 0) continue;
                this.mBeans.remove(metricData.objectName);
                this.unregisterMBeanIgnoreError(metricData.objectName);
                continue;
            }
            metricData.wasPresent = false;
        }
    }

    static String escapeObjectNameValue(String name) {
        if (name.indexOf(44) < 0 && name.indexOf(61) < 0 && name.indexOf(58) < 0 && name.indexOf(42) < 0 && name.indexOf(63) < 0 && name.indexOf(34) < 0 && name.indexOf(10) < 0) {
            return name;
        }
        return "\"" + name.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("*", "\\*").replace("?", "\\?") + '\"';
    }

    @Override
    public void shutdown() {
        ObjectName name;
        this.isShutdown = true;
        try {
            name = new ObjectName("com.hazelcast*:instance=" + this.instanceNameEscaped + ",type=Metrics,*");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Exception when unregistering JMX beans", e);
        }
        for (ObjectName bean : this.platformMBeanServer.queryNames(name, null)) {
            this.unregisterMBeanIgnoreError(bean);
        }
    }

    private static class MetricData {
        ObjectName objectName;
        String metric;
        String unit;
        boolean wasPresent;

        MetricData(String metricName, String instanceNameEscaped, String domainPrefix) {
            List<Map.Entry<String, String>> tagsList = metricName.startsWith("[") && metricName.endsWith("]") ? MetricsUtil.parseMetricName(metricName) : MetricData.parseOldMetricName(metricName);
            StringBuilder mBeanTags = new StringBuilder();
            String module = null;
            this.metric = "metric";
            this.unit = "unknown";
            int tag = 0;
            block12: for (Map.Entry<String, String> entry : tagsList) {
                switch (entry.getKey()) {
                    case "unit": {
                        this.unit = entry.getValue();
                        continue block12;
                    }
                    case "module": {
                        module = entry.getValue();
                        continue block12;
                    }
                    case "metric": {
                        this.metric = entry.getValue();
                        continue block12;
                    }
                }
                if (mBeanTags.length() > 0) {
                    mBeanTags.append(',');
                }
                mBeanTags.append("tag").append(tag++).append('=');
                if (entry.getKey().length() == 0) {
                    mBeanTags.append(JmxPublisher.escapeObjectNameValue(entry.getValue()));
                    continue;
                }
                mBeanTags.append(JmxPublisher.escapeObjectNameValue(entry.getKey() + '=' + entry.getValue()));
            }
            assert (this.metric != null) : "metric == null";
            StringBuilder objectNameStr = new StringBuilder(mBeanTags.length() + 64);
            objectNameStr.append(domainPrefix);
            if (module != null) {
                objectNameStr.append('.').append(module);
            }
            objectNameStr.append(":type=Metrics");
            objectNameStr.append(",instance=").append(instanceNameEscaped);
            if (mBeanTags.length() > 0) {
                objectNameStr.append(',').append((CharSequence)mBeanTags);
            }
            try {
                this.objectName = new ObjectName(objectNameStr.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        }

        private static List<Map.Entry<String, String>> parseOldMetricName(String name) {
            ArrayList<Map.Entry<String, String>> res = new ArrayList<Map.Entry<String, String>>();
            boolean inBracket = false;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch == '.' && !inBracket) {
                    if (builder.length() > 0) {
                        res.add(Util.entry("", builder.toString()));
                    }
                    builder.setLength(0);
                    continue;
                }
                builder.append(ch);
                if (ch == '[') {
                    inBracket = true;
                    continue;
                }
                if (ch != ']') continue;
                inBracket = false;
            }
            if (builder.length() > 0) {
                res.add(Util.entry("metric", builder.toString()));
            }
            return res;
        }
    }
}

