/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.impl.operation.SnapshotOperation;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SnapshotContext {
    public static final int NO_SNAPSHOT = -1;
    private final ILogger logger;
    private final String jobNameAndExecutionId;
    private final ProcessingGuarantee guarantee;
    private final AtomicLong lastSnapshotId;
    private volatile boolean isTerminal;
    private int numTasklets = Integer.MIN_VALUE;
    private int numHigherPriorityTasklets = Integer.MIN_VALUE;
    private final AtomicInteger numRemainingTasklets = new AtomicInteger();
    private final AtomicReference<Throwable> snapshotError = new AtomicReference();
    private boolean snapshotPostponed;
    private volatile CompletableFuture<SnapshotOperation.SnapshotOperationResult> future;
    private final AtomicLong totalBytes = new AtomicLong();
    private final AtomicLong totalKeys = new AtomicLong();
    private final AtomicLong totalChunks = new AtomicLong();
    private boolean isCancelled;

    SnapshotContext(ILogger logger, String jobNameAndExecutionId, long lastSnapshotId, ProcessingGuarantee guarantee) {
        this.jobNameAndExecutionId = jobNameAndExecutionId;
        this.lastSnapshotId = new AtomicLong(lastSnapshotId);
        this.guarantee = guarantee;
        this.logger = logger;
    }

    long lastSnapshotId() {
        return this.lastSnapshotId.get();
    }

    boolean isTerminalSnapshot() {
        return this.isTerminal;
    }

    ProcessingGuarantee processingGuarantee() {
        return this.guarantee;
    }

    synchronized void initTaskletCount(int taskletCount, int highPriorityTaskletCount) {
        assert (this.numTasklets == Integer.MIN_VALUE) : "Tasklet count already set once.";
        assert (taskletCount >= highPriorityTaskletCount) : "taskletCount=" + taskletCount + ", highPriorityTaskletCount=" + highPriorityTaskletCount;
        assert (taskletCount > 0) : "taskletCount=" + taskletCount;
        assert (highPriorityTaskletCount >= 0) : "highPriorityTaskletCount=" + highPriorityTaskletCount;
        this.numTasklets = taskletCount;
        this.numHigherPriorityTasklets = highPriorityTaskletCount;
    }

    synchronized CompletableFuture<SnapshotOperation.SnapshotOperationResult> startNewSnapshot(long snapshotId, boolean isTerminal) {
        assert (snapshotId == this.lastSnapshotId.get() + 1L) : "new snapshotId not incremented by 1. Previous=" + this.lastSnapshotId + ", new=" + snapshotId;
        assert (this.numTasklets >= 0) : "numTasklets=" + this.numTasklets;
        if (this.isCancelled) {
            throw new CancellationException("execution cancelled");
        }
        this.isTerminal = isTerminal;
        int newNumRemainingTasklets = this.numRemainingTasklets.addAndGet(this.numTasklets);
        assert (newNumRemainingTasklets - this.numTasklets <= 0) : "previous snapshot was not finished, numRemainingTasklets=" + (newNumRemainingTasklets - this.numTasklets);
        if (this.numHigherPriorityTasklets == 0) {
            this.lastSnapshotId.set(snapshotId);
        } else {
            this.logger.warning("Snapshot " + snapshotId + " for " + this.jobNameAndExecutionId + " is postponed until all higher priority vertices are completed (number of such vertices = " + this.numHigherPriorityTasklets + ')');
            this.snapshotPostponed = true;
        }
        if (this.numTasklets == 0) {
            return CompletableFuture.completedFuture(new SnapshotOperation.SnapshotOperationResult(0L, 0L, 0L, null));
        }
        this.future = new CompletableFuture<SnapshotOperation.SnapshotOperationResult>();
        CompletableFuture<SnapshotOperation.SnapshotOperationResult> res = this.future;
        if (newNumRemainingTasklets == 0) {
            this.handleSnapshotDone();
        }
        return res;
    }

    synchronized void taskletDone(long lastSnapshotId, boolean isHigherPrioritySource) {
        assert (this.numTasklets > 0) : "numTasklets=" + this.numTasklets;
        assert (lastSnapshotId <= this.lastSnapshotId.get() + 1L) : "this.lastSnapshotId=" + this.lastSnapshotId.get() + "tasklet.lastSnapshotId=" + lastSnapshotId;
        --this.numTasklets;
        if (isHigherPrioritySource) {
            assert (this.numHigherPriorityTasklets > 0) : "numHigherPriorityTasklets=" + this.numHigherPriorityTasklets;
            --this.numHigherPriorityTasklets;
            if (this.numHigherPriorityTasklets == 0 && this.snapshotPostponed) {
                this.lastSnapshotId.incrementAndGet();
                this.logger.info("Postponed snapshot " + this.lastSnapshotId + " for " + this.jobNameAndExecutionId + " started");
            }
        }
        if (this.lastSnapshotId.get() > lastSnapshotId) {
            this.snapshotDoneForTasklet(0L, 0L, 0L);
        } else if (this.lastSnapshotId.get() < lastSnapshotId) {
            this.numRemainingTasklets.incrementAndGet();
        }
    }

    void snapshotDoneForTasklet(long numBytes, long numKeys, long numChunks) {
        this.totalBytes.addAndGet(numBytes);
        this.totalKeys.addAndGet(numKeys);
        this.totalChunks.addAndGet(numChunks);
        if (this.numRemainingTasklets.decrementAndGet() == 0) {
            this.handleSnapshotDone();
        }
    }

    synchronized void cancel() {
        if (this.future != null) {
            this.reportError(new CancellationException("execution cancelled"));
            this.handleSnapshotDone();
        }
        this.isCancelled = true;
    }

    private synchronized void handleSnapshotDone() {
        if (this.isCancelled) {
            assert (this.future == null) : "future=" + this.future;
            return;
        }
        this.future.complete(new SnapshotOperation.SnapshotOperationResult(this.totalBytes.get(), this.totalKeys.get(), this.totalChunks.get(), this.snapshotError.get()));
        this.future = null;
        this.snapshotError.set(null);
        this.totalBytes.set(0L);
        this.totalKeys.set(0L);
        this.totalChunks.set(0L);
    }

    void reportError(Throwable ex) {
        this.snapshotError.compareAndSet(null, ex);
    }

    public AtomicInteger getNumRemainingTasklets() {
        return this.numRemainingTasklets;
    }
}

