/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.Operation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LiveOperationRegistry {
    final ConcurrentHashMap<Address, Map<Long, Operation>> liveOperations = new ConcurrentHashMap();

    public void register(Operation operation) {
        Map callIds = this.liveOperations.computeIfAbsent(operation.getCallerAddress(), key -> new ConcurrentHashMap());
        if (callIds.putIfAbsent(operation.getCallId(), operation) != null) {
            throw new IllegalStateException("Duplicate operation during registration of operation=" + operation);
        }
    }

    public void deregister(Operation operation) {
        Map<Long, Operation> operations = this.liveOperations.get(operation.getCallerAddress());
        if (operations == null) {
            throw new IllegalStateException("Missing address during de-registration of operation=" + operation);
        }
        if (operations.remove(operation.getCallId()) == null) {
            throw new IllegalStateException("Missing operation during de-registration of operation=" + operation);
        }
    }

    public void populate(LiveOperations liveOperations) {
        this.liveOperations.forEach((key, value) -> value.keySet().forEach(callId -> liveOperations.add((Address)key, (long)callId)));
    }
}

