/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.WatermarkEmissionPolicy;
import com.hazelcast.jet.core.WatermarkPolicy;
import com.hazelcast.jet.function.DistributedObjLongBiFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToLongFunction;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class WatermarkGenerationParams<T>
implements Serializable {
    public static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static final DistributedSupplier<WatermarkPolicy> NO_WATERMARKS = () -> new WatermarkPolicy(){

        @Override
        public long reportEvent(long timestamp) {
            return Long.MIN_VALUE;
        }

        @Override
        public long getCurrentWatermark() {
            return Long.MIN_VALUE;
        }
    };
    private final DistributedToLongFunction<? super T> timestampFn;
    private final DistributedObjLongBiFunction<? super T, ?> wrapFn;
    private final DistributedSupplier<? extends WatermarkPolicy> newWmPolicyFn;
    private final WatermarkEmissionPolicy wmEmitPolicy;
    private final long idleTimeoutMillis;

    private WatermarkGenerationParams(@Nonnull DistributedToLongFunction<? super T> timestampFn, @Nonnull DistributedObjLongBiFunction<? super T, ?> wrapFn, @Nonnull DistributedSupplier<? extends WatermarkPolicy> newWmPolicyFn, @Nonnull WatermarkEmissionPolicy wmEmitPolicy, long idleTimeoutMillis) {
        this.timestampFn = timestampFn;
        this.newWmPolicyFn = newWmPolicyFn;
        this.wmEmitPolicy = wmEmitPolicy;
        this.wrapFn = wrapFn;
        this.idleTimeoutMillis = idleTimeoutMillis;
    }

    public static <T> WatermarkGenerationParams<T> wmGenParams(@Nonnull DistributedToLongFunction<? super T> timestampFn, @Nonnull DistributedObjLongBiFunction<? super T, ?> wrapFn, @Nonnull DistributedSupplier<? extends WatermarkPolicy> newWmPolicyFn, @Nonnull WatermarkEmissionPolicy wmEmitPolicy, long idleTimeoutMillis) {
        return new WatermarkGenerationParams<T>(timestampFn, wrapFn, newWmPolicyFn, wmEmitPolicy, idleTimeoutMillis);
    }

    public static <T> WatermarkGenerationParams<T> wmGenParams(@Nonnull DistributedToLongFunction<? super T> timestampFn, @Nonnull DistributedSupplier<? extends WatermarkPolicy> wmPolicy, @Nonnull WatermarkEmissionPolicy wmEmitPolicy, long idleTimeoutMillis) {
        return WatermarkGenerationParams.wmGenParams(timestampFn, (event, timestamp) -> event, wmPolicy, wmEmitPolicy, idleTimeoutMillis);
    }

    public static <T> WatermarkGenerationParams<T> noWatermarks() {
        return WatermarkGenerationParams.wmGenParams(i -> Long.MIN_VALUE, NO_WATERMARKS, WatermarkEmissionPolicy.noThrottling(), -1L);
    }

    @Nonnull
    public DistributedToLongFunction<? super T> timestampFn() {
        return this.timestampFn;
    }

    @Nonnull
    public DistributedObjLongBiFunction<? super T, ?> wrapFn() {
        return this.wrapFn;
    }

    @Nonnull
    public DistributedSupplier<? extends WatermarkPolicy> newWmPolicyFn() {
        return this.newWmPolicyFn;
    }

    @Nonnull
    public WatermarkEmissionPolicy wmEmitPolicy() {
        return this.wmEmitPolicy;
    }

    public long idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    @Nonnull
    public WatermarkGenerationParams<T> withEmitPolicy(WatermarkEmissionPolicy emitPolicy) {
        return WatermarkGenerationParams.wmGenParams(this.timestampFn, this.wrapFn, this.newWmPolicyFn, emitPolicy, this.idleTimeoutMillis);
    }
}

