/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.DiagnosticProcessors;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.pipeline.FileSinkBuilder;
import com.hazelcast.jet.pipeline.JmsSinkBuilder;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.map.EntryProcessor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jms.ConnectionFactory;

public final class Sinks {
    private Sinks() {
    }

    @Nonnull
    public static <T> Sink<T> fromProcessor(@Nonnull String sinkName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return new SinkImpl(sinkName, metaSupplier);
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> map(@Nonnull String mapName) {
        return Sinks.fromProcessor("mapSink(" + mapName + ')', SinkProcessors.writeMapP(mapName));
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> map(@Nonnull IMap<? super K, ? super V> map) {
        return Sinks.map(map.getName());
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteMapSink(" + mapName + ')', SinkProcessors.writeRemoteMapP(mapName, clientConfig));
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithMerging(@Nonnull String mapName, @Nonnull DistributedFunction<? super T, ? extends K> toKeyFn, @Nonnull DistributedFunction<? super T, ? extends V> toValueFn, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.fromProcessor("mapWithMergingSink(" + mapName + ')', SinkProcessors.mergeMapP(mapName, toKeyFn, toValueFn, mergeFn));
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithMerging(@Nonnull IMap<? super K, ? super V> map, @Nonnull DistributedFunction<? super T, ? extends K> toKeyFn, @Nonnull DistributedFunction<? super T, ? extends V> toValueFn, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.mapWithMerging(map.getName(), toKeyFn, toValueFn, mergeFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> remoteMapWithMerging(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedFunction<? super T, ? extends K> toKeyFn, @Nonnull DistributedFunction<? super T, ? extends V> toValueFn, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.fromProcessor("remoteMapWithMergingSink(" + mapName + ')', SinkProcessors.mergeRemoteMapP(mapName, clientConfig, toKeyFn, toValueFn, mergeFn));
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> mapWithMerging(@Nonnull String mapName, @Nonnull DistributedBinaryOperator<? super V> mergeFn) {
        return Sinks.fromProcessor("mapWithMergingSink(" + mapName + ')', SinkProcessors.mergeMapP(mapName, Map.Entry::getKey, DistributedFunctions.entryValue(), mergeFn));
    }

    @Nonnull
    public static <K, V, V_IN extends V> Sink<Map.Entry<K, V_IN>> mapWithMerging(@Nonnull IMap<? super K, V> map, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.mapWithMerging(map.getName(), mergeFn);
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> remoteMapWithMerging(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.fromProcessor("remoteMapWithMergingSink(" + mapName + ')', SinkProcessors.mergeRemoteMapP(mapName, clientConfig, Map.Entry::getKey, DistributedFunctions.entryValue(), mergeFn));
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithUpdating(@Nonnull String mapName, @Nonnull DistributedFunction<? super T, ? extends K> toKeyFn, @Nonnull DistributedBiFunction<? super V, ? super T, ? extends V> updateFn) {
        return Sinks.fromProcessor("mapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, toKeyFn, updateFn));
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithUpdating(@Nonnull IMap<? super K, ? super V> map, @Nonnull DistributedFunction<? super T, ? extends K> toKeyFn, @Nonnull DistributedBiFunction<? super V, ? super T, ? extends V> updateFn) {
        return Sinks.mapWithUpdating(map.getName(), toKeyFn, updateFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> remoteMapWithUpdating(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedFunction<? super T, ? extends K> toKeyFn, @Nonnull DistributedBiFunction<? super V, ? super T, ? extends V> updateFn) {
        return Sinks.fromProcessor("remoteMapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, toKeyFn, updateFn));
    }

    @Nonnull
    public static <K, V, E extends Map.Entry<K, V>> Sink<E> mapWithUpdating(@Nonnull String mapName, @Nonnull DistributedBiFunction<? super V, ? super E, ? extends V> updateFn) {
        return Sinks.fromProcessor("mapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, e -> e.getKey(), updateFn));
    }

    @Nonnull
    public static <K, V, E extends Map.Entry<K, V>> Sink<E> mapWithUpdating(@Nonnull IMap<? super K, ? super V> map, @Nonnull DistributedBiFunction<? super V, ? super E, ? extends V> updateFn) {
        return Sinks.mapWithUpdating(map.getName(), updateFn);
    }

    @Nonnull
    public static <K, V, E extends Map.Entry<K, V>> Sink<E> remoteMapWithUpdating(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedBiFunction<? super V, ? super E, ? extends V> updateFn) {
        return Sinks.fromProcessor("remoteMapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, e -> e.getKey(), updateFn));
    }

    @Nonnull
    public static <E, K, V> Sink<E> mapWithEntryProcessor(@Nonnull String mapName, @Nonnull DistributedFunction<? super E, ? extends K> toKeyFn, @Nonnull DistributedFunction<? super E, ? extends EntryProcessor<K, V>> toEntryProcessorFn) {
        return Sinks.fromProcessor("mapWithEntryProcessorSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, toKeyFn, toEntryProcessorFn));
    }

    @Nonnull
    public static <T, K, V> Sink<T> mapWithEntryProcessor(@Nonnull IMap<? super K, ? super V> map, @Nonnull DistributedFunction<? super T, ? extends K> toKeyFn, @Nonnull DistributedFunction<? super T, ? extends EntryProcessor<K, V>> toEntryProcessorFn) {
        return Sinks.mapWithEntryProcessor(map.getName(), toKeyFn, toEntryProcessorFn);
    }

    @Nonnull
    public static <E, K, V> Sink<E> remoteMapWithEntryProcessor(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedFunction<? super E, ? extends K> toKeyFn, @Nonnull DistributedFunction<? super E, ? extends EntryProcessor<K, V>> toEntryProcessorFn) {
        return Sinks.fromProcessor("remoteMapWithEntryProcessorSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, toKeyFn, toEntryProcessorFn));
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> cache(@Nonnull String cacheName) {
        return Sinks.fromProcessor("cacheSink(" + cacheName + ')', SinkProcessors.writeCacheP(cacheName));
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> remoteCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteCacheSink(" + cacheName + ')', SinkProcessors.writeRemoteCacheP(cacheName, clientConfig));
    }

    @Nonnull
    public static <T> Sink<T> list(@Nonnull String listName) {
        return Sinks.fromProcessor("listSink(" + listName + ')', SinkProcessors.writeListP(listName));
    }

    @Nonnull
    public static <T> Sink<T> list(@Nonnull IList<? super T> list) {
        return Sinks.list(list.getName());
    }

    @Nonnull
    public static <T> Sink<T> remoteList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteListSink(" + listName + ')', SinkProcessors.writeRemoteListP(listName, clientConfig));
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port, @Nonnull DistributedFunction<? super T, ? extends String> toStringFn, @Nonnull Charset charset) {
        return Sinks.fromProcessor("socketSink(" + host + ':' + port + ')', SinkProcessors.writeSocketP(host, port, toStringFn, charset));
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port, @Nonnull DistributedFunction<? super T, ? extends String> toStringFn) {
        return Sinks.socket(host, port, toStringFn, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port) {
        return Sinks.socket(host, port, Object::toString);
    }

    @Nonnull
    public static <T> FileSinkBuilder<T> filesBuilder(@Nonnull String directoryName) {
        return new FileSinkBuilder(directoryName);
    }

    @Nonnull
    public static <T> Sink<T> files(@Nonnull String directoryName) {
        return Sinks.filesBuilder(directoryName).build();
    }

    @Nonnull
    public static <T> Sink<T> logger(@Nonnull DistributedFunction<? super T, String> toStringFn) {
        return Sinks.fromProcessor("loggerSink", DiagnosticProcessors.writeLoggerP(toStringFn));
    }

    @Nonnull
    public static <T> Sink<T> logger() {
        return Sinks.logger(Object::toString);
    }

    @Nonnull
    public static <T> Sink<T> noop() {
        return Sinks.fromProcessor("noop", ProcessorMetaSupplier.preferLocalParallelismOne(Processors.noopP()));
    }

    @Nonnull
    public static <T> Sink<T> jmsQueue(@Nonnull DistributedSupplier<ConnectionFactory> factorySupplier, @Nonnull String name) {
        return Sinks.jmsQueueBuilder(factorySupplier).destinationName(name).build();
    }

    @Nonnull
    public static <T> JmsSinkBuilder<T> jmsQueueBuilder(@Nonnull DistributedSupplier<ConnectionFactory> factorySupplier) {
        return new JmsSinkBuilder(factorySupplier, false);
    }

    @Nonnull
    public static <T> Sink<T> jmsTopic(@Nonnull DistributedSupplier<ConnectionFactory> factorySupplier, @Nonnull String name) {
        return Sinks.jmsTopicBuilder(factorySupplier).destinationName(name).build();
    }

    @Nonnull
    public static <T> JmsSinkBuilder<T> jmsTopicBuilder(@Nonnull DistributedSupplier<ConnectionFactory> factorySupplier) {
        return new JmsSinkBuilder(factorySupplier, true);
    }

    @Nonnull
    public static <T> Sink<T> jdbc(@Nonnull String updateQuery, @Nonnull DistributedSupplier<Connection> connectionSupplier, @Nonnull DistributedBiConsumer<PreparedStatement, T> bindFn) {
        return Sinks.fromProcessor("jdbcSink", SinkProcessors.writeJdbcP(updateQuery, connectionSupplier, bindFn));
    }

    @Nonnull
    public static <T> Sink<T> jdbc(@Nonnull String updateQuery, @Nonnull String connectionUrl, @Nonnull DistributedBiConsumer<PreparedStatement, T> bindFn) {
        return Sinks.jdbc(updateQuery, () -> DriverManager.getConnection(connectionUrl), bindFn);
    }
}

