/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public final class SinkBuilder<W, T> {
    private final DistributedFunction<? super Processor.Context, ? extends W> createFn;
    private final String name;
    private DistributedBiConsumer<? super W, ? super T> receiveFn;
    private DistributedConsumer<? super W> flushFn = DistributedConsumer.noop();
    private DistributedConsumer<? super W> destroyFn = DistributedConsumer.noop();
    private int preferredLocalParallelism = 1;

    private SinkBuilder(@Nonnull String name, @Nonnull DistributedFunction<? super Processor.Context, ? extends W> createFn) {
        Util.checkSerializable(createFn, "createFn");
        this.name = name;
        this.createFn = createFn;
    }

    @Nonnull
    public static <W> SinkBuilder<W, Void> sinkBuilder(@Nonnull String name, @Nonnull DistributedFunction<Processor.Context, ? extends W> createFn) {
        return new SinkBuilder(name, createFn);
    }

    @Nonnull
    public <T_NEW> SinkBuilder<W, T_NEW> receiveFn(@Nonnull DistributedBiConsumer<? super W, ? super T_NEW> receiveFn) {
        Util.checkSerializable(receiveFn, "receiveFn");
        SinkBuilder newThis = this;
        newThis.receiveFn = receiveFn;
        return newThis;
    }

    @Nonnull
    public SinkBuilder<W, T> flushFn(@Nonnull DistributedConsumer<? super W> flushFn) {
        Util.checkSerializable(flushFn, "flushFn");
        this.flushFn = flushFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<W, T> destroyFn(@Nonnull DistributedConsumer<? super W> destroyFn) {
        Util.checkSerializable(destroyFn, "destroyFn");
        this.destroyFn = destroyFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<W, T> preferredLocalParallelism(int preferredLocalParallelism) {
        Vertex.checkLocalParallelism(preferredLocalParallelism);
        this.preferredLocalParallelism = preferredLocalParallelism;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        Preconditions.checkNotNull(this.receiveFn, "receiveFn must be set");
        DistributedSupplier<Processor> supplier = SinkProcessors.writeBufferedP(this.createFn, this.receiveFn, this.flushFn, this.destroyFn);
        return new SinkImpl(this.name, ProcessorMetaSupplier.of(supplier, this.preferredLocalParallelism));
    }
}

