/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.WatermarkGenerationParams;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.StreamSource;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StreamSourceTransform<T>
extends AbstractTransform
implements StreamSource<T> {
    private final Function<? super WatermarkGenerationParams<? super T>, ? extends ProcessorMetaSupplier> metaSupplierFn;
    private final boolean emitsWatermarks;
    @Nullable
    private WatermarkGenerationParams<? super T> wmParams;

    public StreamSourceTransform(@Nonnull String name, @Nullable WatermarkGenerationParams<? super T> initialWmParams, @Nonnull Function<? super WatermarkGenerationParams<? super T>, ? extends ProcessorMetaSupplier> metaSupplierFn, boolean emitsWatermarks) {
        super(name, Collections.emptyList());
        this.wmParams = initialWmParams;
        this.metaSupplierFn = metaSupplierFn;
        this.emitsWatermarks = emitsWatermarks;
    }

    public StreamSourceTransform(@Nonnull String name, @Nonnull Function<? super WatermarkGenerationParams<? super T>, ? extends ProcessorMetaSupplier> metaSupplierFn, boolean emitsWatermarks) {
        this(name, null, metaSupplierFn, emitsWatermarks);
    }

    @Override
    public void addToDag(Planner p) {
        if (this.emitsWatermarks || this.wmParams == null) {
            p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), this.localParallelism(), this.metaSupplierFn.apply(this.wmParams != null ? this.wmParams : WatermarkGenerationParams.noWatermarks()));
        } else {
            String v1name = p.uniqueVertexName(this.name(), "");
            Vertex v1 = p.dag.newVertex(v1name, this.metaSupplierFn.apply(this.wmParams)).localParallelism(this.localParallelism());
            Planner.PlannerVertex pv2 = p.addVertex((Transform)this, v1name + "-insertWM", this.localParallelism(), Processors.insertWatermarksP(this.wmParams));
            p.dag.edge(Edge.between(v1, pv2.v).isolated());
        }
    }

    @Nullable
    public WatermarkGenerationParams<? super T> getWmParams() {
        return this.wmParams;
    }

    public void setWmGenerationParams(@Nonnull WatermarkGenerationParams<? super T> wmParams) {
        this.wmParams = wmParams;
    }

    public boolean emitsJetEvents() {
        return this.wmParams != null;
    }
}

