/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobResult
implements IdentifiedDataSerializable {
    private String coordinatorUUID;
    private long jobId;
    private JobConfig jobConfig;
    private long creationTime;
    private long completionTime;
    private Throwable failure;

    public JobResult() {
    }

    public JobResult(long jobId, @Nonnull JobConfig jobConfig, @Nonnull String coordinatorUUID, long creationTime, long completionTime, @Nullable Throwable failure) {
        this.jobId = jobId;
        this.jobConfig = jobConfig;
        this.coordinatorUUID = coordinatorUUID;
        this.creationTime = creationTime;
        this.completionTime = completionTime;
        this.failure = failure;
    }

    public long getJobId() {
        return this.jobId;
    }

    @Nonnull
    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    @Nonnull
    public String getCoordinatorUUID() {
        return this.coordinatorUUID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    public boolean isSuccessful() {
        return this.failure == null;
    }

    public boolean isSuccessfulOrCancelled() {
        return this.failure == null || this.failure instanceof CancellationException;
    }

    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    @Nullable
    public String getFailureReason() {
        return this.failure == null ? null : this.failure.toString();
    }

    @Nonnull
    public JobStatus getJobStatus() {
        return this.isSuccessfulOrCancelled() ? JobStatus.COMPLETED : JobStatus.FAILED;
    }

    @Nonnull
    public CompletableFuture<Void> asCompletableFuture() {
        return this.failure == null ? CompletableFuture.completedFuture(null) : Util.exceptionallyCompletedFuture(this.failure);
    }

    @Nonnull
    public String getJobNameOrId() {
        return this.jobConfig.getName() != null ? this.jobConfig.getName() : com.hazelcast.jet.Util.idToString(this.jobId);
    }

    public String toString() {
        return "JobResult{coordinatorUUID='" + this.coordinatorUUID + '\'' + ", jobId=" + com.hazelcast.jet.Util.idToString(this.jobId) + ", name=" + this.jobConfig.getName() + ", creationTime=" + Util.toLocalDateTime(this.creationTime) + ", completionTime=" + Util.toLocalDateTime(this.completionTime) + ", failure=" + this.failure + '}';
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeObject(this.jobConfig);
        out.writeUTF(this.coordinatorUUID);
        out.writeLong(this.creationTime);
        out.writeLong(this.completionTime);
        out.writeObject(this.failure);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.jobConfig = (JobConfig)in.readObject();
        this.coordinatorUUID = in.readUTF();
        this.creationTime = in.readLong();
        this.completionTime = in.readLong();
        this.failure = (Throwable)in.readObject();
    }
}

