/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.util.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class InstanceConfig {
    public static final int DEFAULT_FLOW_CONTROL_PERIOD_MS = 100;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    private static final long SCALE_UP_DELAY_MILLIS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private int cooperativeThreadCount = Runtime.getRuntime().availableProcessors();
    private int flowControlPeriodMs = 100;
    private int backupCount = 1;
    private long scaleUpDelayMillis = SCALE_UP_DELAY_MILLIS_DEFAULT;

    @Nonnull
    public InstanceConfig setCooperativeThreadCount(int size) {
        Preconditions.checkPositive(size, "cooperativeThreadCount should be a positive number");
        this.cooperativeThreadCount = size;
        return this;
    }

    public int getCooperativeThreadCount() {
        return this.cooperativeThreadCount;
    }

    @Nonnull
    public InstanceConfig setFlowControlPeriodMs(int flowControlPeriodMs) {
        Preconditions.checkPositive(flowControlPeriodMs, "flowControlPeriodMs should be a positive number");
        this.flowControlPeriodMs = flowControlPeriodMs;
        return this;
    }

    public int getFlowControlPeriodMs() {
        return this.flowControlPeriodMs;
    }

    @Nonnull
    public InstanceConfig setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount(newBackupCount, 0);
        this.backupCount = newBackupCount;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public InstanceConfig setScaleUpDelayMillis(long millis) {
        Preconditions.checkNotNegative(millis, "The delay must be >=0");
        this.scaleUpDelayMillis = millis;
        return this;
    }

    public long getScaleUpDelayMillis() {
        return this.scaleUpDelayMillis;
    }
}

