/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapMergeRunnable;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.merge.IgnoreMergingEntryMapMergePolicy;
import com.hazelcast.map.merge.MergePolicyProvider;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.merge.AbstractSplitBrainHandlerService;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

class MapSplitBrainHandlerService
extends AbstractSplitBrainHandlerService<RecordStore> {
    private final MapServiceContext mapServiceContext;
    private final MergePolicyProvider mergePolicyProvider;

    MapSplitBrainHandlerService(MapServiceContext mapServiceContext) {
        super(mapServiceContext.getNodeEngine());
        this.mapServiceContext = mapServiceContext;
        this.mergePolicyProvider = mapServiceContext.getMergePolicyProvider();
    }

    @Override
    protected Runnable newMergeRunnable(Map<String, Collection<RecordStore>> collectedStores, Map<String, Collection<RecordStore>> collectedStoresWithLegacyPolicies, Collection<RecordStore> backupStores, NodeEngine nodeEngine) {
        return new MapMergeRunnable(collectedStores, collectedStoresWithLegacyPolicies, backupStores, this.mapServiceContext, this);
    }

    @Override
    protected String getDataStructureName(RecordStore recordStore) {
        return recordStore.getName();
    }

    @Override
    protected Object getMergePolicy(String dataStructureName) {
        MapConfig mapConfig = this.getMapConfig(dataStructureName);
        MergePolicyConfig mergePolicyConfig = mapConfig.getMergePolicyConfig();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyConfig.getPolicy());
    }

    @Override
    protected boolean isDiscardPolicy(Object mergePolicy) {
        return mergePolicy instanceof IgnoreMergingEntryMapMergePolicy || super.isDiscardPolicy(mergePolicy);
    }

    @Override
    protected Collection<Iterator<RecordStore>> iteratorsOf(int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        Collection<RecordStore> recordStores = partitionContainer.getAllRecordStores();
        return Collections.singletonList(recordStores.iterator());
    }

    @Override
    protected void destroyStore(RecordStore store) {
        assert (store.getMapContainer().getMapConfig().getInMemoryFormat() != InMemoryFormat.NATIVE);
        store.getMapContainer().getIndexes(store.getPartitionId()).clearIndexes();
        store.destroy();
    }

    public MapConfig getMapConfig(String dataStructureName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(dataStructureName);
        return mapContainer.getMapConfig();
    }
}

