/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.proxy.NearCachedMapProxyImpl;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;

class MapRemoteService
implements RemoteService {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    MapRemoteService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        Config config = this.nodeEngine.getConfig();
        MapConfig mapConfig = config.findMapConfig(name);
        ConfigValidator.checkMapConfig(mapConfig);
        ConfigValidator.checkMergePolicySupportsInMemoryFormat(name, mapConfig.getMergePolicyConfig().getPolicy(), mapConfig.getInMemoryFormat(), this.nodeEngine.getClusterService().getClusterVersion(), true, this.nodeEngine.getLogger(this.getClass()));
        if (mapConfig.isNearCacheEnabled()) {
            ConfigValidator.checkNearCacheConfig(name, mapConfig.getNearCacheConfig(), config.getNativeMemoryConfig(), false);
            return new NearCachedMapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
        }
        return new MapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.mapServiceContext.destroyMap(name);
    }
}

