/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.pipeline.WindowDefinition;
import javax.annotation.Nonnull;

public class SessionWindowDef<T>
implements WindowDefinition {
    private static final int MAX_FRAME_RATE = 100;
    private static final int MIN_WMS_PER_SESSION = 100;
    private final long sessionTimeout;

    SessionWindowDef(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    @Nonnull
    public WindowDefinition.WindowKind kind() {
        return WindowDefinition.WindowKind.SESSION;
    }

    @Nonnull
    public SessionWindowDef<T> downcast() {
        return this;
    }

    @Override
    public long watermarkFrameSize() {
        return Math.min(100L, this.sessionTimeout / 100L);
    }

    public long sessionTimeout() {
        return this.sessionTimeout;
    }
}

