/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import java.lang.reflect.Field;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T readStaticFieldOrNull(String classname, String fieldName) {
        try {
            Class<?> clazz = Class.forName(classname);
            return ReflectionUtils.readStaticField(clazz, fieldName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static <T> T readStaticField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return (T)field.get(null);
    }
}

