/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

public final class ObjectArrayHook
implements SerializerHook<Object[]> {
    @Override
    public Class<Object[]> getSerializationType() {
        return Object[].class;
    }

    @Override
    public Serializer createSerializer() {
        return new StreamSerializer<Object[]>(){

            @Override
            public int getTypeId() {
                return -302;
            }

            @Override
            public void destroy() {
            }

            @Override
            public void write(ObjectDataOutput out, Object[] array) throws IOException {
                out.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    out.writeObject(array[i]);
                }
            }

            @Override
            public Object[] read(ObjectDataInput in) throws IOException {
                int length = in.readInt();
                Object[] array = new Object[length];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readObject();
                }
                return array;
            }
        };
    }

    @Override
    public boolean isOverwritable() {
        return true;
    }
}

