/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.util.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class GroupP<K, A, R, OUT>
extends AbstractProcessor {
    @Nonnull
    private final List<DistributedFunction<?, ? extends K>> groupKeyFns;
    @Nonnull
    private final AggregateOperation<A, R> aggrOp;
    private final Map<K, A> keyToAcc = new HashMap<K, A>();
    private final Traverser<OUT> resultTraverser;

    public GroupP(@Nonnull List<DistributedFunction<?, ? extends K>> groupKeyFns, @Nonnull AggregateOperation<A, R> aggrOp, @Nonnull BiFunction<? super K, ? super R, OUT> mapToOutputFn) {
        Preconditions.checkTrue(groupKeyFns.size() == aggrOp.arity(), groupKeyFns.size() + " key functions provided for " + aggrOp.arity() + "-arity aggregate operation");
        this.groupKeyFns = groupKeyFns;
        this.aggrOp = aggrOp;
        this.resultTraverser = Traversers.traverseStream(this.keyToAcc.entrySet().stream().map(e -> mapToOutputFn.apply((Object)e.getKey(), (Object)aggrOp.finishFn().apply(e.getValue()))));
    }

    public <T> GroupP(@Nonnull DistributedFunction<? super T, ? extends K> groupKeyFn, @Nonnull AggregateOperation1<? super T, A, R> aggrOp, @Nonnull BiFunction<? super K, ? super R, OUT> mapToOutputFn) {
        this(Collections.singletonList(groupKeyFn), aggrOp, mapToOutputFn);
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        Function keyFn = this.groupKeyFns.get(ordinal);
        Object key = keyFn.apply(item);
        Object acc = this.keyToAcc.computeIfAbsent(key, k -> this.aggrOp.createFn().get());
        this.aggrOp.accumulateFn(ordinal).accept(acc, item);
        return true;
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.resultTraverser);
    }
}

