/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.Sink;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public class SinkImpl<T>
implements Sink<T> {
    private final String name;
    private ProcessorMetaSupplier metaSupplier;
    private final AtomicBoolean isAssignedToStage = new AtomicBoolean();

    public SinkImpl(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier) {
        this.name = name;
        this.metaSupplier = metaSupplier;
    }

    @Nonnull
    public ProcessorMetaSupplier metaSupplier() {
        return this.metaSupplier;
    }

    @Override
    public String name() {
        return this.name;
    }

    void onAssignToStage() {
        if (this.isAssignedToStage.getAndSet(true)) {
            throw new IllegalStateException("Sink " + this.name + " was already assigned to a sink stage");
        }
    }
}

